DROP INDEX ADR.ACTIVEAGG_PERID_NU;

CREATE INDEX ADR.ACTIVEAGG_PERID_NU ON ADR.ACTIVEAGG
(PERID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
NOLOGGING
LOCAL (  
  PARTITION P1
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          4M
                NEXT             4M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.ACTIVEAGG_TRACKER_PK;

CREATE UNIQUE INDEX ADR.ACTIVEAGG_TRACKER_PK ON ADR.ACTIVEAGG_TRACKER
(ACTIVEAGG_TRACKER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_H_PERSON_ID;

CREATE INDEX ADR.ACT_H_PERSON_ID ON ADR.ACTIVATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_H_PK;

CREATE UNIQUE INDEX ADR.ACT_H_PK ON ADR.ACTIVATION_H
(ACTIVATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_MHDS_FK_I;

CREATE INDEX ADR.ACT_MHDS_FK_I ON ADR.ACTIVATION
(STD_MHDATASOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_NC_FK_I;

CREATE INDEX ADR.ACT_NC_FK_I ON ADR.ACTIVATION
(STD_NAMEDCONTINGENCY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_PK;

CREATE UNIQUE INDEX ADR.ACT_PK ON ADR.ACTIVATION
(ACTIVATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_PRSN_FK_I;

CREATE INDEX ADR.ACT_PRSN_FK_I ON ADR.ACTIVATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_SO_FK_I;

CREATE INDEX ADR.ACT_SO_FK_I ON ADR.ACTIVATION
(STD_SPECIALOPERATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ACT_TR_FK_I;

CREATE INDEX ADR.ACT_TR_FK_I ON ADR.ACTIVATION
(STD_TERMINATIONREASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRCONFH_PK;

CREATE UNIQUE INDEX ADR.ADDRCONFH_PK ON ADR.ADDR_CONFIDENTIAL_DTL_H
(ADDR_CONFIDENTIAL_DTL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRCONF_ADDR_FK_I;

CREATE INDEX ADR.ADDRCONF_ADDR_FK_I ON ADR.ADDR_CONFIDENTIAL_DTL
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRCONF_CNFADDRTYP_FK_I;

CREATE INDEX ADR.ADDRCONF_CNFADDRTYP_FK_I ON ADR.ADDR_CONFIDENTIAL_DTL
(STD_CONFIDENTIALADDRESSCAT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRCONF_PK;

CREATE UNIQUE INDEX ADR.ADDRCONF_PK ON ADR.ADDR_CONFIDENTIAL_DTL
(ADDR_CONFIDENTIAL_DTL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRESS_H_ID_FK_I;

CREATE INDEX ADR.ADDRESS_H_ID_FK_I ON ADR.CORRESPONDENCE
(ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRESS_ID_NU_I;

CREATE INDEX ADR.ADDRESS_ID_NU_I ON ADR.ADDRESS_H
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.ADDRH_PK;

CREATE UNIQUE INDEX ADR.ADDRH_PK ON ADR.ADDRESS_H
(ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDRH_PRSNID_NU_I;

CREATE INDEX ADR.ADDRH_PRSNID_NU_I ON ADR.ADDRESS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_INSURANCE_FK_I;

CREATE INDEX ADR.ADDR_INSURANCE_FK_I ON ADR.ADDRESS
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_PK;

CREATE UNIQUE INDEX ADR.ADDR_PK ON ADR.ADDRESS
(ADDRESS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_PRSNREL_FK_I;

CREATE INDEX ADR.ADDR_PRSNREL_FK_I ON ADR.ADDRESS
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_PRSN_FK_I;

CREATE INDEX ADR.ADDR_PRSN_FK_I ON ADR.ADDRESS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STDADDRTYPE_FK_I;

CREATE INDEX ADR.ADDR_STDADDRTYPE_FK_I ON ADR.ADDRESS
(STD_ADDRESSTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STDINST_FK_I;

CREATE INDEX ADR.ADDR_STDINST_FK_I ON ADR.ADDRESS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_ADDRCHGSRC_FK_I;

CREATE INDEX ADR.ADDR_STD_ADDRCHGSRC_FK_I ON ADR.ADDRESS
(ADDRESS_CHANGE_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_ADDRDELFLR_FK_I;

CREATE INDEX ADR.ADDR_STD_ADDRDELFLR_FK_I ON ADR.ADDRESS
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_NCOADELTYP_FK_I;

CREATE INDEX ADR.ADDR_STD_NCOADELTYP_FK_I ON ADR.ADDRESS
(NCOA_DELIVERY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_NCOASTATYP_FK_I;

CREATE INDEX ADR.ADDR_STD_NCOASTATYP_FK_I ON ADR.ADDRESS
(NCOA_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_NCOAZIPMCH_FK_I;

CREATE INDEX ADR.ADDR_STD_NCOAZIPMCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADDR_STD_NCOAZIPNOMTCH_FK_I;

CREATE INDEX ADR.ADDR_STD_NCOAZIPNOMTCH_FK_I ON ADR.ADDRESS
(NCOA_ZIP_NO_MATCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADR_DBVER_CR_UK;

CREATE UNIQUE INDEX ADR.ADR_DBVER_CR_UK ON ADR.ADR_DB_VER
(ADR_CR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ADR_DBVER_VERSION_UK;

CREATE UNIQUE INDEX ADR.ADR_DBVER_VERSION_UK ON ADR.ADR_DB_VER
(DB_VERSION, ADR_CR)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.APARAM_STD_APARAMTYP_FK_I;

CREATE INDEX ADR.APARAM_STD_APARAMTYP_FK_I ON ADR.APP_PARAMETER
(APP_PARAMETER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.APARAM_STD_APARAMU_FK_I;

CREATE INDEX ADR.APARAM_STD_APARAMU_FK_I ON ADR.APP_PARAMETER
(APP_PARAMETER_UNIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.APPLPARAM_PK;

CREATE UNIQUE INDEX ADR.APPLPARAM_PK ON ADR.APP_PARAMETER
(APP_PARAMETER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.APPLPARAM_U_CODE_UK;

CREATE UNIQUE INDEX ADR.APPLPARAM_U_CODE_UK ON ADR.APP_PARAMETER
(PARAMETER_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BATREQFACH_PK;

CREATE UNIQUE INDEX ADR.BATREQFACH_PK ON ADR.BATCH_REQUEST_FACILITY_H
(BATCH_REQUEST_FACILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BATREQFAC_HNDBATREQ_FK_I;

CREATE INDEX ADR.BATREQFAC_HNDBATREQ_FK_I ON ADR.BATCH_REQUEST_FACILITY
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BATREQFAC_PK;

CREATE UNIQUE INDEX ADR.BATREQFAC_PK ON ADR.BATCH_REQUEST_FACILITY
(BATCH_REQUEST_FACILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BATREQPRRGRPH_PK;

CREATE UNIQUE INDEX ADR.BATREQPRRGRPH_PK ON ADR.BATCH_REQUEST_PRIORITY_GROUP_H
(BATCH_REQUEST_PRI_GRP_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BATREQPRRGRP_HNDBTCREQ_FK_I;

CREATE INDEX ADR.BATREQPRRGRP_HNDBTCREQ_FK_I ON ADR.BATCH_REQUEST_PRIORITY_GROUP
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENTRVLH_PK;

CREATE UNIQUE INDEX ADR.BENTRVLH_PK ON ADR.BENEFICIARY_TRAVEL_H
(BENEFICIARY_TRAVEL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENTRVLH_PRSNID_NU_I;

CREATE INDEX ADR.BENTRVLH_PRSNID_NU_I ON ADR.BENEFICIARY_TRAVEL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENTRVL_PK;

CREATE UNIQUE INDEX ADR.BENTRVL_PK ON ADR.BENEFICIARY_TRAVEL
(BENEFICIARY_TRAVEL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENTRVL_PRSN_FK_I;

CREATE INDEX ADR.BENTRVL_PRSN_FK_I ON ADR.BENEFICIARY_TRAVEL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENTRVL_STDINST_FK_I;

CREATE INDEX ADR.BENTRVL_STDINST_FK_I ON ADR.BENEFICIARY_TRAVEL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENVISSUMH_PK;

CREATE UNIQUE INDEX ADR.BENVISSUMH_PK ON ADR.BENEFICIARY_VISIT_SUMMARY_H
(BENEFICIARY_VISIT_SUMMARY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENVISSUMH_PRSNID_NU_I;

CREATE INDEX ADR.BENVISSUMH_PRSNID_NU_I ON ADR.BENEFICIARY_VISIT_SUMMARY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENVISSUM_PK;

CREATE UNIQUE INDEX ADR.BENVISSUM_PK ON ADR.BENEFICIARY_VISIT_SUMMARY
(BENEFICIARY_VISIT_SUMMARY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENVISSUM_PRSN_FK_I;

CREATE INDEX ADR.BENVISSUM_PRSN_FK_I ON ADR.BENEFICIARY_VISIT_SUMMARY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BENVISSUM_STDINST_FK_I;

CREATE INDEX ADR.BENVISSUM_STDINST_FK_I ON ADR.BENEFICIARY_VISIT_SUMMARY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMSTH_PK;

CREATE UNIQUE INDEX ADR.BNFYMSTH_PK ON ADR.BENEFICIARY_MST_H
(BENEFICIARY_MST_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMSTH_PRSNID_NU_I;

CREATE INDEX ADR.BNFYMSTH_PRSNID_NU_I ON ADR.BENEFICIARY_MST_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMST_PK;

CREATE UNIQUE INDEX ADR.BNFYMST_PK ON ADR.BENEFICIARY_MST
(BENEFICIARY_MST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMST_PRSN_FK_I;

CREATE INDEX ADR.BNFYMST_PRSN_FK_I ON ADR.BENEFICIARY_MST
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMST_STDINST_FK_I;

CREATE INDEX ADR.BNFYMST_STDINST_FK_I ON ADR.BENEFICIARY_MST
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYMST_STD_MSTST_FK_I;

CREATE INDEX ADR.BNFYMST_STD_MSTST_FK_I ON ADR.BENEFICIARY_MST
(MST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTRH_PK;

CREATE UNIQUE INDEX ADR.BNFYNTRH_PK ON ADR.BENEFICIARY_NTR_H
(BENEFICIARY_NTR_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTRH_PRSNID_NU_I;

CREATE INDEX ADR.BNFYNTRH_PRSNID_NU_I ON ADR.BENEFICIARY_NTR_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTR_PK;

CREATE UNIQUE INDEX ADR.BNFYNTR_PK ON ADR.BENEFICIARY_NTR
(BENEFICIARY_NTR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTR_PRSN_FK_I;

CREATE INDEX ADR.BNFYNTR_PRSN_FK_I ON ADR.BENEFICIARY_NTR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTR_STDINST_FK_I;

CREATE INDEX ADR.BNFYNTR_STDINST_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTR_STDINST_H_FK_I;

CREATE INDEX ADR.BNFYNTR_STDINST_H_FK_I ON ADR.BENEFICIARY_NTR
(NTR_DIAGNOSIS_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYNTR_STD_NTRVRFYMTD_FK_I;

CREATE INDEX ADR.BNFYNTR_STD_NTRVRFYMTD_FK_I ON ADR.BENEFICIARY_NTR
(NTR_VERIFY_METHOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYSCIH_PK;

CREATE UNIQUE INDEX ADR.BNFYSCIH_PK ON ADR.BENEFICIARY_SCI_H
(BENEFICIARY_SCI_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYSCI_PK;

CREATE UNIQUE INDEX ADR.BNFYSCI_PK ON ADR.BENEFICIARY_SCI
(BENEFICIARY_SCI_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYSCI_PRSN_FK_I;

CREATE INDEX ADR.BNFYSCI_PRSN_FK_I ON ADR.BENEFICIARY_SCI
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BNFYSCI_STDSPINAL_FK_I;

CREATE INDEX ADR.BNFYSCI_STDSPINAL_FK_I ON ADR.BENEFICIARY_SCI
(STD_SPINALINJURYCODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BRSRVER_PK;

CREATE UNIQUE INDEX ADR.BRSRVER_PK ON ADR.BROKER_SERVICE_ERROR
(BROKER_SERVICE_ERROR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BRSRVL1_PK;

CREATE UNIQUE INDEX ADR.BRSRVL1_PK ON ADR.BROKER_SERVICE_LOG
(BROKER_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.BRSRVLP_PERSMSGSTAT_I;

CREATE INDEX ADR.BRSRVLP_PERSMSGSTAT_I ON ADR.BROKER_SERVICE_LOG
(PERSON_ID, STD_MESSAGESTATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BRSRVL_TRN_FK_I;

CREATE INDEX ADR.BRSRVL_TRN_FK_I ON ADR.BROKER_SERVICE_LOG
(TRANSMISSION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BRSRVPL_BRSRVL_FK_I;

CREATE INDEX ADR.BRSRVPL_BRSRVL_FK_I ON ADR.BROKER_SERVICE_PAYLOAD
(BROKER_SERVICE_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BRSRVPL_PK;

CREATE UNIQUE INDEX ADR.BRSRVPL_PK ON ADR.BROKER_SERVICE_PAYLOAD
(BROKER_SERVICE_PAYLOAD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.BTCREQPRRGRP_PK;

CREATE UNIQUE INDEX ADR.BTCREQPRRGRP_PK ON ADR.BATCH_REQUEST_PRIORITY_GROUP
(BATCH_REQUEST_PRIORITY_GRP_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDECH_PK;

CREATE UNIQUE INDEX ADR.CANDECH_PK ON ADR.CANCEL_DECLINE_H
(CANCEL_DECLINE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDECH_PRSNID_NU_I;

CREATE INDEX ADR.CANDECH_PRSNID_NU_I ON ADR.CANCEL_DECLINE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDEC_PK;

CREATE UNIQUE INDEX ADR.CANDEC_PK ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDEC_PRSN_FK_I;

CREATE INDEX ADR.CANDEC_PRSN_FK_I ON ADR.CANCEL_DECLINE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDEC_STD_CANDECRSN_FK_I;

CREATE INDEX ADR.CANDEC_STD_CANDECRSN_FK_I ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CANDEC_STD_CANDEC_FK_I;

CREATE INDEX ADR.CANDEC_STD_CANDEC_FK_I ON ADR.CANCEL_DECLINE
(CANCEL_DECLINE_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CASSCERTIFIEDTYPE_PK;

CREATE UNIQUE INDEX ADR.CASSCERTIFIEDTYPE_PK ON ADR.CASSCERTIFIEDTYPE
(CASSCERTIFIEDTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRC_CATDSBLTY_FK_I;

CREATE INDEX ADR.CATDSBLPRC_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRC_DIAGXTRMTY_FK_I;

CREATE INDEX ADR.CATDSBLPRC_DIAGXTRMTY_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(AFFECTED_EXTREMITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRC_PK;

CREATE UNIQUE INDEX ADR.CATDSBLPRC_PK ON ADR.CAT_DSBLTY_PROCEDURE
(CAT_DSBLTY_PROCEDURE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRC_STD_PROCCD_FK_I;

CREATE INDEX ADR.CATDSBLPRC_STD_PROCCD_FK_I ON ADR.CAT_DSBLTY_PROCEDURE
(PROCEDURE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRH_CATDSBLTY_NU_I;

CREATE INDEX ADR.CATDSBLPRH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_PROCEDURE_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLPRH_PK;

CREATE UNIQUE INDEX ADR.CATDSBLPRH_PK ON ADR.CAT_DSBLTY_PROCEDURE_H
(CAT_DSBLTY_PROCEDURE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTYH_PK;

CREATE UNIQUE INDEX ADR.CATDSBLTYH_PK ON ADR.CATASTROPHIC_DISABILITY_H
(CATASTROPHIC_DISABILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTYH_PRSNID_NU_I;

CREATE INDEX ADR.CATDSBLTYH_PRSNID_NU_I ON ADR.CATASTROPHIC_DISABILITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTY_PK;

CREATE UNIQUE INDEX ADR.CATDSBLTY_PK ON ADR.CATASTROPHIC_DISABILITY
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTY_PRSN_FK_I;

CREATE INDEX ADR.CATDSBLTY_PRSN_FK_I ON ADR.CATASTROPHIC_DISABILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTY_STDINST_FK_I;

CREATE INDEX ADR.CATDSBLTY_STDINST_FK_I ON ADR.CATASTROPHIC_DISABILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSBLTY_STD_EVALMTHD_FK_I;

CREATE INDEX ADR.CATDSBLTY_STD_EVALMTHD_FK_I ON ADR.CATASTROPHIC_DISABILITY
(CAT_DSBLTY_EVAL_MTHD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCONDH_CATDSBLTY_NU_I;

CREATE INDEX ADR.CATDSCONDH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_CONDITION_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCONDH_PK;

CREATE UNIQUE INDEX ADR.CATDSCONDH_PK ON ADR.CAT_DSBLTY_CONDITION_H
(CAT_DSBLTY_CONDITION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCOND_CATDSBLTY_FK_I;

CREATE INDEX ADR.CATDSCOND_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCOND_PK;

CREATE UNIQUE INDEX ADR.CATDSCOND_PK ON ADR.CAT_DSBLTY_CONDITION
(CAT_DSBLTY_CONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCOND_STDPERM_FK_I;

CREATE INDEX ADR.CATDSCOND_STDPERM_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDPERM_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCOND_STDYESNO_FK_I;

CREATE INDEX ADR.CATDSCOND_STDYESNO_FK_I ON ADR.CAT_DSBLTY_CONDITION
(PRMNT_DSBLTY_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSCON_STD_CNDN_FK_I;

CREATE INDEX ADR.CATDSCON_STD_CNDN_FK_I ON ADR.CAT_DSBLTY_CONDITION
(CONDITION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSDIAGH_CATDSBLTY_NU_I;

CREATE INDEX ADR.CATDSDIAGH_CATDSBLTY_NU_I ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSDIAGH_PK;

CREATE UNIQUE INDEX ADR.CATDSDIAGH_PK ON ADR.CAT_DSBLTY_DIAGNOSIS_H
(CAT_DSBLTY_DIAGNOSIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSDIAG_CATDSBLTY_FK_I;

CREATE INDEX ADR.CATDSDIAG_CATDSBLTY_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSDIAG_PK;

CREATE UNIQUE INDEX ADR.CATDSDIAG_PK ON ADR.CAT_DSBLTY_DIAGNOSIS
(CAT_DSBLTY_DIAGNOSIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CATDSDIAG_STD_DIAGCD_FK_I;

CREATE INDEX ADR.CATDSDIAG_STD_DIAGCD_FK_I ON ADR.CAT_DSBLTY_DIAGNOSIS
(DIAGNOSIS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK;

CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_H_PK ON ADR.CAT_DSBLTY_DESCRIPTOR_H
(CAT_DSBLTY_DESCRIPTOR_ID_H)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK;

CREATE UNIQUE INDEX ADR.CAT_DSBLTY_DESCRIPTOR_PK ON ADR.CAT_DSBLTY_DESCRIPTOR
(CAT_DSBLTY_DESCRIPTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CAT_DSBL_CAT_DSBL_DESC_FK_I;

CREATE INDEX ADR.CAT_DSBL_CAT_DSBL_DESC_FK_I ON ADR.CAT_DSBLTY_DESCRIPTOR
(CATASTROPHIC_DISABILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNFILETRANSHID_PK_I;

CREATE UNIQUE INDEX ADR.CCNFILETRANSHID_PK_I ON ADR.CCN_FILETRANSFER_H
(CCN_FILETRANSFER_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNFITRANSFER_TRNSTYPEID_FK_I;

CREATE INDEX ADR.CCNFITRANSFER_TRNSTYPEID_FK_I ON ADR.CCN_FILETRANSFER
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNFITRANSF_VCADSTPIDD_FK_I;

CREATE INDEX ADR.CCNFITRANSF_VCADSTPIDD_FK_I ON ADR.CCN_FILETRANSFER
(VCADMISTATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNRSERVLOG_CONTRACTORID_FK_I;

CREATE INDEX ADR.CCNRSERVLOG_CONTRACTORID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNRSERVLOG_PERSONID_FK_I;

CREATE INDEX ADR.CCNRSERVLOG_PERSONID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNRSERVLOG_VCADMNSTATPID_FK_I;

CREATE INDEX ADR.CCNRSERVLOG_VCADMNSTATPID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(VCADMINSTATUS_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_CCNSERVLOG_ID_PK;

CREATE UNIQUE INDEX ADR.CCNSERVLOG_CCNSERVLOG_ID_PK ON ADR.CCN_SERVICE_LOG
(CCN_SERVICE_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_MAILADDRHID_FK_I;

CREATE INDEX ADR.CCNSERVLOG_MAILADDRHID_FK_I ON ADR.CCN_SERVICE_LOG
(MAILING_ADDRESS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_PERSION_ID_NU;

CREATE INDEX ADR.CCNSERVLOG_PERSION_ID_NU ON ADR.CCN_SERVICE_LOG
(PERSON_ID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_TRANSMISSION_ID_NU;

CREATE INDEX ADR.CCNSERVLOG_TRANSMISSION_ID_NU ON ADR.CCN_SERVICE_LOG
(TRANSMISSION_DATE)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_TRNSMNTYPEID_NU_I;

CREATE INDEX ADR.CCNSERVLOG_TRNSMNTYPEID_NU_I ON ADR.CCN_SERVICE_LOG
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCNSERVLOG_VCELIGBTY_H_ID_FK_I;

CREATE INDEX ADR.CCNSERVLOG_VCELIGBTY_H_ID_FK_I ON ADR.CCN_SERVICE_LOG
(VCELIGIBILITY_H_ID)
  TABLESPACE M_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION SRLOG_TRANSID_P01
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ( SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP1      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP2      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP3      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP4      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP5      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP6      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP7      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP8      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP9      TABLESPACE M_INDEX_01,
    SUBPARTITION SRLOG_TRANSID_P01_SRLOG_SP10      TABLESPACE M_INDEX_01 ),  
  PARTITION
    NOLOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
    STORE IN (M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01,M_INDEX_01)
)
NOPARALLEL;
DROP INDEX ADR.CCN_CONTRACTOR_H_PK_I;

CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_H_PK_I ON ADR.CCN_CONTRACTOR_H
(CCN_CONTRACTOR_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_CONTRACTOR_ID_FK_I;

CREATE INDEX ADR.CCN_CONTRACTOR_ID_FK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_CONTRACTOR_PK_I;

CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_PK_I ON ADR.CCN_CONTRACTOR
(CCN_CONTRACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_CONTRACTOR_REGION_H_PK_I;

CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_REGION_H_PK_I ON ADR.CCN_CONTRACTOR_REGION_H
(CCN_CONTRACTOR_REGION_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_CONTRACTOR_REGION_PK_I;

CREATE UNIQUE INDEX ADR.CCN_CONTRACTOR_REGION_PK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_CONTRACTOR_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_FILETRANS_ID_PK_I;

CREATE UNIQUE INDEX ADR.CCN_FILETRANS_ID_PK_I ON ADR.CCN_FILETRANSFER
(CCN_FILETRANSFER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_RECEIVED_SERVICE_LOG_PK_I;

CREATE UNIQUE INDEX ADR.CCN_RECEIVED_SERVICE_LOG_PK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_RECEIVED_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_REGION_ID_FK_I;

CREATE INDEX ADR.CCN_REGION_ID_FK_I ON ADR.CCN_CONTRACTOR_REGION
(CCN_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_REGION_PK_I;

CREATE UNIQUE INDEX ADR.CCN_REGION_PK_I ON ADR.CCN_REGION
(CCN_REGION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_REGION_STATE_H_PK;

CREATE UNIQUE INDEX ADR.CCN_REGION_STATE_H_PK ON ADR.CCN_REGION_STATE_H
(CCN_REGION_STATE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CCN_REGION_STATE_PK_I;

CREATE UNIQUE INDEX ADR.CCN_REGION_STATE_PK_I ON ADR.CCN_REGION_STATE
(CCN_REGION_STATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CLOSE_APL_RSN_TYPE_CD_UK;

CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_CD_UK ON ADR.CLOSE_APL_RSN_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CLOSE_APL_RSN_TYPE_NM_UK;

CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_NM_UK ON ADR.CLOSE_APL_RSN_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CLOSE_APL_RSN_TYPE_PK;

CREATE UNIQUE INDEX ADR.CLOSE_APL_RSN_TYPE_PK ON ADR.CLOSE_APL_RSN_TYPE
(CLOSE_APL_RSN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CL_VERIFICATION_METHOD_H_PK;

CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_H_PK ON ADR.CL_VERIFICATION_METHOD_H
(CL_VERIFICATION_METHOD_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CL_VERIFICATION_METHOD_PK;

CREATE UNIQUE INDEX ADR.CL_VERIFICATION_METHOD_PK ON ADR.CL_VERIFICATION_METHOD
(CL_VERIFICATION_METHOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSDH_PK;

CREATE UNIQUE INDEX ADR.CMBTEPSDH_PK ON ADR.COMBAT_EPISODE_H
(COMBAT_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSDH_PRSNID_NU_I;

CREATE INDEX ADR.CMBTEPSDH_PRSNID_NU_I ON ADR.COMBAT_EPISODE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_PK;

CREATE UNIQUE INDEX ADR.CMBTEPSD_PK ON ADR.COMBAT_EPISODE
(COMBAT_EPISODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_PRSN_FK_I;

CREATE INDEX ADR.CMBTEPSD_PRSN_FK_I ON ADR.COMBAT_EPISODE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_STDCBTPAY_FK_I;

CREATE INDEX ADR.CMBTEPSD_STDCBTPAY_FK_I ON ADR.COMBAT_EPISODE
(COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_STDCMBTLOC_FK_I;

CREATE INDEX ADR.CMBTEPSD_STDCMBTLOC_FK_I ON ADR.COMBAT_EPISODE
(COMBATLOCATIONTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_STDINST_FK_I;

CREATE INDEX ADR.CMBTEPSD_STDINST_FK_I ON ADR.COMBAT_EPISODE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTEPSD_STDOEFSRC_FK_I;

CREATE INDEX ADR.CMBTEPSD_STDOEFSRC_FK_I ON ADR.COMBAT_EPISODE
(OEFOIFSOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAYH_PK;

CREATE UNIQUE INDEX ADR.CMBTPAYH_PK ON ADR.COMBAT_PAY_H
(COMBAT_PAY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAYH_PRSNID_NU_I;

CREATE INDEX ADR.CMBTPAYH_PRSNID_NU_I ON ADR.COMBAT_PAY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAY_PK;

CREATE UNIQUE INDEX ADR.CMBTPAY_PK ON ADR.COMBAT_PAY
(COMBAT_PAY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAY_PRSN_FK_I;

CREATE INDEX ADR.CMBTPAY_PRSN_FK_I ON ADR.COMBAT_PAY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAY_STDCBTPTYP_FK_I;

CREATE INDEX ADR.CMBTPAY_STDCBTPTYP_FK_I ON ADR.COMBAT_PAY
(STD_COMBATPAYTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAY_STDCBTSLOC_FK_I;

CREATE INDEX ADR.CMBTPAY_STDCBTSLOC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICELOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMBTPAY_STDCBTSSRC_FK_I;

CREATE INDEX ADR.CMBTPAY_STDCBTSSRC_FK_I ON ADR.COMBAT_PAY
(COMBATSERVICESOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMPRPT_USER_1_FK_I;

CREATE INDEX ADR.CMPRPT_USER_1_FK_I ON ADR.RPT_COMPLETED_REPORTS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMRPT_STD_RPTOUTFILE_FK_I;

CREATE INDEX ADR.CMRPT_STD_RPTOUTFILE_FK_I ON ADR.RPT_COMPLETED_REPORTS
(RPT_OUTPUT_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CMRPT_STD_RPTSTDRPT_FK_I;

CREATE INDEX ADR.CMRPT_STD_RPTSTDRPT_FK_I ON ADR.RPT_COMPLETED_REPORTS
(RPT_STANDARD_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDRH_PK;

CREATE UNIQUE INDEX ADR.CNFADDRH_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(CONFIDENTIAL_ADDR_CATGRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDRH_PRSNID_NU_I;

CREATE INDEX ADR.CNFADDRH_PRSNID_NU_I ON ADR.CONFIDENTIAL_ADDR_CATGRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDR_PK;

CREATE UNIQUE INDEX ADR.CNFADDR_PK ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_CATGRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDR_PRSN_FK_I;

CREATE INDEX ADR.CNFADDR_PRSN_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDR_STDINST2_FK_I;

CREATE INDEX ADR.CNFADDR_STDINST2_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CNFADDR_STD_CNFADDRCAT_FK_I;

CREATE INDEX ADR.CNFADDR_STD_CNFADDRCAT_FK_I ON ADR.CONFIDENTIAL_ADDR_CATGRY
(CONFIDENTIAL_ADDR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CODE_UK;

CREATE UNIQUE INDEX ADR.CODE_UK ON ADR.TRANSMISSION_TYPE
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMAACERR_COMMAIL_FK_I;

CREATE INDEX ADR.COMAACERR_COMMAIL_FK_I ON ADR.COM_AAC_ERROR_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMAACERR_PK;

CREATE UNIQUE INDEX ADR.COMAACERR_PK ON ADR.COM_AAC_ERROR_DETAIL
(COM_AAC_ERROR_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMAACERR_STD_COMERRTYP_FK_I;

CREATE INDEX ADR.COMAACERR_STD_COMERRTYP_FK_I ON ADR.COM_AAC_ERROR_DETAIL
(COM_AAC_ERROR_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMCNLPR_COMMAIL_FK_I;

CREATE INDEX ADR.COMCNLPR_COMMAIL_FK_I ON ADR.COM_CANCELED_REQUEST
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMCNLPR_PK;

CREATE UNIQUE INDEX ADR.COMCNLPR_PK ON ADR.COM_CANCELED_REQUEST
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMEMLTPL_PK;

CREATE UNIQUE INDEX ADR.COMEMLTPL_PK ON ADR.COM_EMAIL_TEMPLATE
(COM_EMAIL_TEMPLATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMFRMSTAT_COMTRANLOG_FK_I;

CREATE INDEX ADR.COMFRMSTAT_COMTRANLOG_FK_I ON ADR.COM_FORM_STATISTICS
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMFRMSTAT_PK;

CREATE UNIQUE INDEX ADR.COMFRMSTAT_PK ON ADR.COM_FORM_STATISTICS
(COM_FORM_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMLTRTPL_PK;

CREATE UNIQUE INDEX ADR.COMLTRTPL_PK ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMLTRTPL_STD_COMLTRGTYPE_FK_I;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRGTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_GENERATED_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMLTRTPL_STD_COMLTRTYPE_FK_I;

CREATE INDEX ADR.COMLTRTPL_STD_COMLTRTYPE_FK_I ON ADR.COM_LETTER_TEMPLATE
(COM_LETTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_BARCODE_NU_I;

CREATE INDEX ADR.COMMAIL_BARCODE_NU_I ON ADR.COM_MAILING
(BARCODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_COMLETTYPE_FK_I;

CREATE INDEX ADR.COMMAIL_COMLETTYPE_FK_I ON ADR.COM_MAILING
(COM_LETTER_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_COMLTRTPL_FK_I;

CREATE INDEX ADR.COMMAIL_COMLTRTPL_FK_I ON ADR.COM_MAILING
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_FNAME_FB_I;

CREATE INDEX ADR.COMMAIL_FNAME_FB_I ON ADR.COM_MAILING
(UPPER("FIRST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.COMMAIL_LNAME_FB_I;

CREATE INDEX ADR.COMMAIL_LNAME_FB_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.COMMAIL_LSTNM_CITY_I;

CREATE INDEX ADR.COMMAIL_LSTNM_CITY_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"), UPPER("CITY"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.COMMAIL_LSTNM_ZIP_I;

CREATE INDEX ADR.COMMAIL_LSTNM_ZIP_I ON ADR.COM_MAILING
(UPPER("LAST_NAME"), UPPER("ZIP_CODE"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.COMMAIL_MNAME_FB_I;

CREATE INDEX ADR.COMMAIL_MNAME_FB_I ON ADR.COM_MAILING
(UPPER("MIDDLE_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.COMMAIL_PK;

CREATE UNIQUE INDEX ADR.COMMAIL_PK ON ADR.COM_MAILING
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_PRSN_FK_I;

CREATE INDEX ADR.COMMAIL_PRSN_FK_I ON ADR.COM_MAILING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_SSN_NU_I;

CREATE INDEX ADR.COMMAIL_SSN_NU_I ON ADR.COM_MAILING
(SSN)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_STD_ADDRTYPE_FK_I;

CREATE INDEX ADR.COMMAIL_STD_ADDRTYPE_FK_I ON ADR.COM_MAILING
(ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_STD_COMMLTRG_FK_I;

CREATE INDEX ADR.COMMAIL_STD_COMMLTRG_FK_I ON ADR.COM_MAILING
(COM_MAILING_TRIGGER_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_STD_COMRJCTRSN_FK_I;

CREATE INDEX ADR.COMMAIL_STD_COMRJCTRSN_FK_I ON ADR.COM_MAILING
(COM_AAC_REJECT_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMAIL_WKFCASE_FK_I;

CREATE INDEX ADR.COMMAIL_WKFCASE_FK_I ON ADR.COM_MAILING
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMLSTAT_COMMAIL_FK_I;

CREATE INDEX ADR.COMMLSTAT_COMMAIL_FK_I ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMLSTAT_PK;

CREATE UNIQUE INDEX ADR.COMMLSTAT_PK ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_STATUS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMMLSTAT_STD_COMAILSTAT_FK_I;

CREATE INDEX ADR.COMMLSTAT_STD_COMAILSTAT_FK_I ON ADR.COM_MAILING_STATUS_DETAIL
(COM_MAILING_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRPT_PK;

CREATE UNIQUE INDEX ADR.COMPRPT_PK ON ADR.RPT_COMPLETED_REPORTS
(RPT_COMPLETED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTCHK_COMCNLPR_FK_I;

CREATE INDEX ADR.COMPRTCHK_COMCNLPR_FK_I ON ADR.COM_PRINT_CHECK
(COM_CANCELED_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTCHK_COMMAIL_FK_I;

CREATE INDEX ADR.COMPRTCHK_COMMAIL_FK_I ON ADR.COM_PRINT_CHECK
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTCHK_COMPRTREQ_FK_I;

CREATE INDEX ADR.COMPRTCHK_COMPRTREQ_FK_I ON ADR.COM_PRINT_CHECK
(COM_PRINT_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTCHK_PK;

CREATE UNIQUE INDEX ADR.COMPRTCHK_PK ON ADR.COM_PRINT_CHECK
(COM_PRINT_CHECK_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTREQ_COMMAIL_FK_I;

CREATE INDEX ADR.COMPRTREQ_COMMAIL_FK_I ON ADR.COM_PRINT_REQUEST
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTREQ_PK;

CREATE UNIQUE INDEX ADR.COMPRTREQ_PK ON ADR.COM_PRINT_REQUEST
(COM_PRINT_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMPRTREQ_U_PRINT_DUPLICATE_UK;

CREATE UNIQUE INDEX ADR.COMPRTREQ_U_PRINT_DUPLICATE_UK ON ADR.COM_PRINT_REQUEST
(PRINT_REQUEST_UNIQUE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMRJCTDTL_COMMAIL_FK_I;

CREATE INDEX ADR.COMRJCTDTL_COMMAIL_FK_I ON ADR.COM_HEC_REJECT_DETAIL
(COM_MAILING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMRJCTDTL_PK;

CREATE UNIQUE INDEX ADR.COMRJCTDTL_PK ON ADR.COM_HEC_REJECT_DETAIL
(COM_HEC_REJECT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMTRANLOG_PK;

CREATE UNIQUE INDEX ADR.COMTRANLOG_PK ON ADR.COM_TRANSMISSION_LOG
(COM_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COMTRANS_STD_MSGTYP_FK_I;

CREATE INDEX ADR.COMTRANS_STD_MSGTYP_FK_I ON ADR.COM_TRANSMISSION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.COM_LETTER_TEMPLATE_ID_FK_I;

CREATE INDEX ADR.COM_LETTER_TEMPLATE_ID_FK_I ON ADR.CORRESPONDENCE
(COM_LETTER_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CONFLDTLH_MILSRVC_NU_I;

CREATE INDEX ADR.CONFLDTLH_MILSRVC_NU_I ON ADR.CONFLICT_DETAIL_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CONFLDTLH_PK;

CREATE UNIQUE INDEX ADR.CONFLDTLH_PK ON ADR.CONFLICT_DETAIL_H
(CONFLICT_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CONFLDTL_MILSRVC_FK_I;

CREATE INDEX ADR.CONFLDTL_MILSRVC_FK_I ON ADR.CONFLICT_DETAIL
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CONFLDTL_PK;

CREATE UNIQUE INDEX ADR.CONFLDTL_PK ON ADR.CONFLICT_DETAIL
(CONFLICT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CONFLDTL_STD_CMBTLOCN_FK_I;

CREATE INDEX ADR.CONFLDTL_STD_CMBTLOCN_FK_I ON ADR.CONFLICT_DETAIL
(STD_COMBATLOCATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_DOCUMENT_PK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_DOCUMENT_PK ON ADR.CORRESPONDENCE_DOCUMENT
(CORRESPONDENCE_DOCUMENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_DOC_ID_FK_I;

CREATE INDEX ADR.CORRESPONDENCE_DOC_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_DOCUMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_H_PK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_H_PK ON ADR.CORRESPONDENCE_H
(CORRESPONDENCE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_PK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_PK ON ADR.CORRESPONDENCE
(CORRESPONDENCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_STATUS_CODE_UK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_STATUS_CODE_UK ON ADR.CORRESPONDENCE_STATUS
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_STATUS_ID_FK_I;

CREATE INDEX ADR.CORRESPONDENCE_STATUS_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_STATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_STATUS_PK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_STATUS_PK ON ADR.CORRESPONDENCE_STATUS
(CORRESPONDENCE_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_TYPE_CODE_UK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_TYPE_CODE_UK ON ADR.CORRESPONDENCE_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_TYPE_ID_FK_I;

CREATE INDEX ADR.CORRESPONDENCE_TYPE_ID_FK_I ON ADR.CORRESPONDENCE
(CORRESPONDENCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_TYPE_NAME_NU_I;

CREATE INDEX ADR.CORRESPONDENCE_TYPE_NAME_NU_I ON ADR.CORRESPONDENCE_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPONDENCE_TYPE_PK;

CREATE UNIQUE INDEX ADR.CORRESPONDENCE_TYPE_PK ON ADR.CORRESPONDENCE_TYPE
(CORRESPONDENCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.CORRESPOND_STATUS_NAME_NU_I;

CREATE INDEX ADR.CORRESPOND_STATUS_NAME_NU_I ON ADR.CORRESPONDENCE_STATUS
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_ACT_FK_I;

CREATE INDEX ADR.DEP_ACT_FK_I ON ADR.DEPLOYMENT
(ACTIVATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_H_PK;

CREATE UNIQUE INDEX ADR.DEP_H_PK ON ADR.DEPLOYMENT_H
(DEPLOYMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_MHDS_FK_I;

CREATE INDEX ADR.DEP_MHDS_FK_I ON ADR.DEPLOYMENT
(STD_MHDATASOURCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_PK;

CREATE UNIQUE INDEX ADR.DEP_PK ON ADR.DEPLOYMENT
(DEPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_SC_FK_I;

CREATE INDEX ADR.DEP_SC_FK_I ON ADR.DEPLOYMENT
(STD_COUNTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_SO_FK_I;

CREATE INDEX ADR.DEP_SO_FK_I ON ADR.DEPLOYMENT
(STD_SPECIALOPERATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DEP_TR_FK_I;

CREATE INDEX ADR.DEP_TR_FK_I ON ADR.DEPLOYMENT
(STD_TERMINATIONREASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRFEM_DLVPRF_FK_I;

CREATE INDEX ADR.DLVPRFEM_DLVPRF_FK_I ON ADR.DELIVERY_PREFERENCE_EMAIL
(DELIVERY_PREFERENCE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRFEM_H_PK;

CREATE UNIQUE INDEX ADR.DLVPRFEM_H_PK ON ADR.DELIVERY_PREFERENCE_EMAIL_H
(DELIVERY_PREFERENCE_EMAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRFEM_PK;

CREATE UNIQUE INDEX ADR.DLVPRFEM_PK ON ADR.DELIVERY_PREFERENCE_EMAIL
(DELIVERY_PREFERENCE_EMAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRFEM_STD_EMAILADDRTYP_FK_I;

CREATE INDEX ADR.DLVPRFEM_STD_EMAILADDRTYP_FK_I ON ADR.DELIVERY_PREFERENCE_EMAIL
(STD_EMAILADDRESSTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRF_DLVPRFSRCTYP_FK_I;

CREATE INDEX ADR.DLVPRF_DLVPRFSRCTYP_FK_I ON ADR.DELIVERY_PREFERENCE
(STD_DELIVERYPREFSRCTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRF_DLVPRFTYP_FK_I;

CREATE INDEX ADR.DLVPRF_DLVPRFTYP_FK_I ON ADR.DELIVERY_PREFERENCE
(STD_DELIVERYPREFERENCETYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRF_H_PK;

CREATE UNIQUE INDEX ADR.DLVPRF_H_PK ON ADR.DELIVERY_PREFERENCE_H
(DELIVERY_PREFERENCE_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRF_PK;

CREATE UNIQUE INDEX ADR.DLVPRF_PK ON ADR.DELIVERY_PREFERENCE
(DELIVERY_PREFERENCE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.DLVPRF_PRSN_FK_I;

CREATE INDEX ADR.DLVPRF_PRSN_FK_I ON ADR.DELIVERY_PREFERENCE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTING_EGTSETTING_FK_I;

CREATE INDEX ADR.EGTSETTING_EGTSETTING_FK_I ON ADR.EGT_SETTING
(REFERENCE_EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTING_PK;

CREATE UNIQUE INDEX ADR.EGTSETTING_PK ON ADR.EGT_SETTING
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTING_STD_EGTTYP_FK_I;

CREATE INDEX ADR.EGTSETTING_STD_EGTTYP_FK_I ON ADR.EGT_SETTING
(EGT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTING_STD_ENRLPGRP_FK_I;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTING_STD_ENRLPSGRP_FK_I;

CREATE INDEX ADR.EGTSETTING_STD_ENRLPSGRP_FK_I ON ADR.EGT_SETTING
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSETTINH_PK;

CREATE UNIQUE INDEX ADR.EGTSETTINH_PK ON ADR.EGT_SETTING_H
(EGT_SETTING_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTATH_PK;

CREATE UNIQUE INDEX ADR.EGTSTATH_PK ON ADR.EGT_STATISTICS_H
(EGT_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTAT_EGTSETTING_FK_I;

CREATE INDEX ADR.EGTSTAT_EGTSETTING_FK_I ON ADR.EGT_STATISTICS
(EGT_SETTING_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTAT_PK;

CREATE UNIQUE INDEX ADR.EGTSTAT_PK ON ADR.EGT_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTAT_STD_EGTPRCST_FK_I;

CREATE INDEX ADR.EGTSTAT_STD_EGTPRCST_FK_I ON ADR.EGT_STATISTICS
(EGT_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTSTICH_PK;

CREATE UNIQUE INDEX ADR.EGTSTSTICH_PK ON ADR.EGT_SITE_STATISTICS_H
(EGT_SITE_STATISTICS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTSTIC_EGTSETTING_FK_I;

CREATE INDEX ADR.EGTSTSTIC_EGTSETTING_FK_I ON ADR.EGT_SITE_STATISTICS
(EGT_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTSTIC_PK;

CREATE UNIQUE INDEX ADR.EGTSTSTIC_PK ON ADR.EGT_SITE_STATISTICS
(EGT_SITE_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EGTSTSTIC_STDINST_FK_I;

CREATE INDEX ADR.EGTSTSTIC_STDINST_FK_I ON ADR.EGT_SITE_STATISTICS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETERH_ENRLMNTDET_NU_I;

CREATE INDEX ADR.ELGBDETERH_ENRLMNTDET_NU_I ON ADR.ELIGIBILITY_DETERMINATION_H
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETERH_PK;

CREATE UNIQUE INDEX ADR.ELGBDETERH_PK ON ADR.ELIGIBILITY_DETERMINATION_H
(ELIGIBILITY_DETERMINATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETER_ENRLMNTDET_FK_I;

CREATE INDEX ADR.ELGBDETER_ENRLMNTDET_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETER_PK;

CREATE UNIQUE INDEX ADR.ELGBDETER_PK ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETER_STDELGFCTR_FK_I;

CREATE INDEX ADR.ELGBDETER_STDELGFCTR_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(STD_ELIGIBILITYFACTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBDETER_STD_ELGBTYCODE_FK_I;

CREATE INDEX ADR.ELGBDETER_STD_ELGBTYCODE_FK_I ON ADR.ELIGIBILITY_DETERMINATION
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFH_PK;

CREATE UNIQUE INDEX ADR.ELGBTYVRFH_PK ON ADR.ELIGIBILITY_VERIFICATION_H
(ELIGIBILITY_VERIFICATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFH_PRSNID_NU_I;

CREATE INDEX ADR.ELGBTYVRFH_PRSNID_NU_I ON ADR.ELIGIBILITY_VERIFICATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_PK;

CREATE UNIQUE INDEX ADR.ELGBTYVRFY_PK ON ADR.ELIGIBILITY_VERIFICATION
(ELIGIBILITY_VERIFICATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_PRSN_FK_I;

CREATE INDEX ADR.ELGBTYVRFY_PRSN_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_STDINST_FK_I;

CREATE INDEX ADR.ELGBTYVRFY_STDINST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_STD_ELGBTST_FK_I;

CREATE INDEX ADR.ELGBTYVRFY_STD_ELGBTST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(ELGBTY_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_STD_ELGVRSRC_FK_I;

CREATE INDEX ADR.ELGBTYVRFY_STD_ELGVRSRC_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(ELGBTY_VRFN_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTYVRFY_STD_VBAQURYST_FK_I;

CREATE INDEX ADR.ELGBTYVRFY_STD_VBAQURYST_FK_I ON ADR.ELIGIBILITY_VERIFICATION
(VBA_QUERY_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTY_STATUS_REASON_CODE_UK;

CREATE UNIQUE INDEX ADR.ELGBTY_STATUS_REASON_CODE_UK ON ADR.ELIGIBILITY_STATUS_REASON
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELGBTY_STATUS_REASON_NM_UK;

CREATE UNIQUE INDEX ADR.ELGBTY_STATUS_REASON_NM_UK ON ADR.ELIGIBILITY_STATUS_REASON
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ELIGIBILITY_STATUS_REASON_PK;

CREATE UNIQUE INDEX ADR.ELIGIBILITY_STATUS_REASON_PK ON ADR.ELIGIBILITY_STATUS_REASON
(ELIGIBILITY_STATUS_REASON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAILH_PK;

CREATE UNIQUE INDEX ADR.EMAILH_PK ON ADR.EMAIL_H
(EMAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAILH_PRSNID_NU_I;

CREATE INDEX ADR.EMAILH_PRSNID_NU_I ON ADR.EMAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_H_ID_FK_I;

CREATE INDEX ADR.EMAIL_H_ID_FK_I ON ADR.CORRESPONDENCE
(EMAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_INSURANCE_FK_I;

CREATE INDEX ADR.EMAIL_INSURANCE_FK_I ON ADR.EMAIL
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_PK;

CREATE UNIQUE INDEX ADR.EMAIL_PK ON ADR.EMAIL
(EMAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_PRSN_FK_I;

CREATE INDEX ADR.EMAIL_PRSN_FK_I ON ADR.EMAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_STDINST2_FK_I;

CREATE INDEX ADR.EMAIL_STDINST2_FK_I ON ADR.EMAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_STDINST_FK_I;

CREATE INDEX ADR.EMAIL_STDINST_FK_I ON ADR.EMAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_STD_EMAILADDRTYP_FK_I;

CREATE INDEX ADR.EMAIL_STD_EMAILADDRTYP_FK_I ON ADR.EMAIL
(EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_STD_EMAILCHGSRC_FK_I;

CREATE INDEX ADR.EMAIL_STD_EMAILCHGSRC_FK_I ON ADR.EMAIL
(EMAIL_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMAIL_TEMPLATE_ID_FK_I;

CREATE INDEX ADR.EMAIL_TEMPLATE_ID_FK_I ON ADR.CORRESPONDENCE
(EMAIL_TEMPLATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMERGRESH_PK;

CREATE UNIQUE INDEX ADR.EMERGRESH_PK ON ADR.EMERGENCY_RESPONSE_H
(EMERGENCY_RESPONSE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMERGRESH_PRSNID_NU_I;

CREATE INDEX ADR.EMERGRESH_PRSNID_NU_I ON ADR.EMERGENCY_RESPONSE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMERGRESP_PK;

CREATE UNIQUE INDEX ADR.EMERGRESP_PK ON ADR.EMERGENCY_RESPONSE
(EMERGENCY_RESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMERGRESP_PRSN_FK_I;

CREATE INDEX ADR.EMERGRESP_PRSN_FK_I ON ADR.EMERGENCY_RESPONSE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMERGRESP_STDEMRGNCY_FK_I;

CREATE INDEX ADR.EMERGRESP_STDEMRGNCY_FK_I ON ADR.EMERGENCY_RESPONSE
(STD_EMERGENCYRESPONSE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOYH_PK;

CREATE UNIQUE INDEX ADR.EMPLOYH_PK ON ADR.EMPLOYMENT_H
(EMPLOYMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_EMPTSTAT_FK_I;

CREATE INDEX ADR.EMPLOY_EMPTSTAT_FK_I ON ADR.EMPLOYMENT
(STD_EMPLOYMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_H_PRSNREL_FK_I;

CREATE INDEX ADR.EMPLOY_H_PRSNREL_FK_I ON ADR.EMPLOYMENT_H
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_H_PRSN_FK_I;

CREATE INDEX ADR.EMPLOY_H_PRSN_FK_I ON ADR.EMPLOYMENT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_PK;

CREATE UNIQUE INDEX ADR.EMPLOY_PK ON ADR.EMPLOYMENT
(EMPLOYMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_PRSNREL_FK_I;

CREATE INDEX ADR.EMPLOY_PRSNREL_FK_I ON ADR.EMPLOYMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.EMPLOY_PRSN_FK_I;

CREATE INDEX ADR.EMPLOY_PRSN_FK_I ON ADR.EMPLOYMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDEH_ENRLMNTDET_NU_I;

CREATE INDEX ADR.ENRLMNTDEH_ENRLMNTDET_NU_I ON ADR.ENROLLMENT_DETERMINATION_H
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDEH_PK;

CREATE UNIQUE INDEX ADR.ENRLMNTDEH_PK ON ADR.ENROLLMENT_DETERMINATION_H
(ENROLLMENT_DETERMINATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDEH_PRSNID_NU_I;

CREATE INDEX ADR.ENRLMNTDEH_PRSNID_NU_I ON ADR.ENROLLMENT_DETERMINATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_EGTSETTING_FK_I;

CREATE INDEX ADR.ENRLMNTDET_EGTSETTING_FK_I ON ADR.ENROLLMENT_DETERMINATION
(EGT_SETTING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_PK;

CREATE UNIQUE INDEX ADR.ENRLMNTDET_PK ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DETERMINATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_PRSN_FK_I;

CREATE INDEX ADR.ENRLMNTDET_PRSN_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_STDINST_FK_I;

CREATE INDEX ADR.ENRLMNTDET_STDINST_FK_I ON ADR.ENROLLMENT_DETERMINATION
(APPLICATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_STD_ENRLPGRP_FK_I;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_STD_ENRLPSGRP_FK_I;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLPSGRP_FK_I ON ADR.ENROLLMENT_DETERMINATION
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_STD_ENRLSRC_FK_I;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSRC_FK_I ON ADR.ENROLLMENT_DETERMINATION
(ENROLLMENT_DATA_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENRLMNTDET_STD_ENRLSTAT_FK_I;

CREATE INDEX ADR.ENRLMNTDET_STD_ENRLSTAT_FK_I ON ADR.ENROLLMENT_DETERMINATION
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLLMENT_DETERM_H_MOD_DT_NDX;

CREATE INDEX ADR.ENROLLMENT_DETERM_H_MOD_DT_NDX ON ADR.ELIGIBILITY_DETERMINATION_H
(RECORD_MODIFIED_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLLMENT_DETERM_MOD_DT_NDX;

CREATE INDEX ADR.ENROLLMENT_DETERM_MOD_DT_NDX ON ADR.ELIGIBILITY_DETERMINATION
(RECORD_MODIFIED_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLOVERH_PK;

CREATE UNIQUE INDEX ADR.ENROLOVERH_PK ON ADR.ENROLLMENT_OVERRIDE_H
(ENROLLMENT_OVERRIDE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLOVERH_PRSNID_NU_I;

CREATE INDEX ADR.ENROLOVERH_PRSNID_NU_I ON ADR.ENROLLMENT_OVERRIDE_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLOVER_PK;

CREATE UNIQUE INDEX ADR.ENROLOVER_PK ON ADR.ENROLLMENT_OVERRIDE
(ENROLLMENT_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLOVER_PRSN_FK_I;

CREATE INDEX ADR.ENROLOVER_PRSN_FK_I ON ADR.ENROLLMENT_OVERRIDE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROLOVER_STDENROVRD_FK_I;

CREATE INDEX ADR.ENROLOVER_STDENROVRD_FK_I ON ADR.ENROLLMENT_OVERRIDE
(STD_ENROLLMENTOVERRIDERSN_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ENROL_FORM_TYP_RPT_FORM_TYP_FK;

CREATE INDEX ADR.ENROL_FORM_TYP_RPT_FORM_TYP_FK ON ADR.RPT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBASISH_PK;

CREATE UNIQUE INDEX ADR.FEEBASISH_PK ON ADR.FEE_BASIS_H
(FEE_BASIS_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBASISH_PRSNID_NU_I;

CREATE INDEX ADR.FEEBASISH_PRSNID_NU_I ON ADR.FEE_BASIS_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBASIS_PK;

CREATE UNIQUE INDEX ADR.FEEBASIS_PK ON ADR.FEE_BASIS
(FEE_BASIS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBASIS_PRSN_FK_I;

CREATE INDEX ADR.FEEBASIS_PRSN_FK_I ON ADR.FEE_BASIS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBASIS_STDINST_FK_I;

CREATE INDEX ADR.FEEBASIS_STDINST_FK_I ON ADR.FEE_BASIS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBSIS_STD_FEEBSISPROG_FK_I;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISPROG_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_PROGRAM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FEEBSIS_STD_FEEBSISTRTMT_FK_I;

CREATE INDEX ADR.FEEBSIS_STD_FEEBSISTRTMT_FK_I ON ADR.FEE_BASIS
(FEE_BASIS_TREATMENT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINASTDTLH_PK;

CREATE UNIQUE INDEX ADR.FINASTDTLH_PK ON ADR.FINANCIAL_ASSET_DETAIL_H
(FINANCIAL_ASSET_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINASTDTL_FINSTATE_FK_I;

CREATE INDEX ADR.FINASTDTL_FINSTATE_FK_I ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINASTDTL_PK;

CREATE UNIQUE INDEX ADR.FINASTDTL_PK ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_ASSET_DETAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINASTDTL_STD_ASSTTYP_FK_I;

CREATE INDEX ADR.FINASTDTL_STD_ASSTTYP_FK_I ON ADR.FINANCIAL_ASSET_DETAIL
(FINANCIAL_ASSET_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINDBTDTLH_PK;

CREATE UNIQUE INDEX ADR.FINDBTDTLH_PK ON ADR.FINANCIAL_DEBT_DETAIL_H
(FINANCIAL_DEBT_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINDBTDTL_FINSTATE_FK_I;

CREATE INDEX ADR.FINDBTDTL_FINSTATE_FK_I ON ADR.FINANCIAL_DEBT_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINDBTDTL_PK;

CREATE UNIQUE INDEX ADR.FINDBTDTL_PK ON ADR.FINANCIAL_DEBT_DETAIL
(FINANCIAL_DEBT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINEXPDTLH_PK;

CREATE UNIQUE INDEX ADR.FINEXPDTLH_PK ON ADR.FINANCIAL_EXPENSE_DETAIL_H
(FINANCIAL_EXPENSE_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINEXPDTL_FINSTATE_FK_I;

CREATE INDEX ADR.FINEXPDTL_FINSTATE_FK_I ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINEXPDTL_PK;

CREATE UNIQUE INDEX ADR.FINEXPDTL_PK ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_EXPENSE_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINEXPDTL_STD_EXPNSTYPE_FK_I;

CREATE INDEX ADR.FINEXPDTL_STD_EXPNSTYPE_FK_I ON ADR.FINANCIAL_EXPENSE_DETAIL
(FINANCIAL_EXPENSE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FININCDTL_STD_INCMTYP_FK_I;

CREATE INDEX ADR.FININCDTL_STD_INCMTYP_FK_I ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_INCOME_TYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FININCMDTH_PK;

CREATE UNIQUE INDEX ADR.FININCMDTH_PK ON ADR.FINANCIAL_INCOME_DETAIL_H
(FINANCIAL_INCOME_DETAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FININCMDTL_FINSTATE_FK_I;

CREATE INDEX ADR.FININCMDTL_FINSTATE_FK_I ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FININCMDTL_PK;

CREATE UNIQUE INDEX ADR.FININCMDTL_PK ON ADR.FINANCIAL_INCOME_DETAIL
(FINANCIAL_INCOME_DETAIL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATEH_FINSTATID_NU_I;

CREATE INDEX ADR.FINSTATEH_FINSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATEH_PK;

CREATE UNIQUE INDEX ADR.FINSTATEH_PK ON ADR.FINANCIAL_STATEMENT_H
(FINANCIAL_STATEMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATEH_PRSNID_NU_I;

CREATE INDEX ADR.FINSTATEH_PRSNID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(PERSON_ID, FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATEH_REFSTATID_NU_I;

CREATE INDEX ADR.FINSTATEH_REFSTATID_NU_I ON ADR.FINANCIAL_STATEMENT_H
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATE_FINSTATE_FK_I;

CREATE INDEX ADR.FINSTATE_FINSTATE_FK_I ON ADR.FINANCIAL_STATEMENT
(REF_FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATE_PK;

CREATE UNIQUE INDEX ADR.FINSTATE_PK ON ADR.FINANCIAL_STATEMENT
(FINANCIAL_STATEMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATE_PRSNREL_FK_I;

CREATE INDEX ADR.FINSTATE_PRSNREL_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FINSTATE_PRSN_FK_I;

CREATE INDEX ADR.FINSTATE_PRSN_FK_I ON ADR.FINANCIAL_STATEMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FIN_STD_FINANCIALMAP_FK_I;

CREATE INDEX ADR.FIN_STD_FINANCIALMAP_FK_I ON ADR.FINANCIAL_STATEMENT
(FIN_STMT_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FUTURE_DISCHARGE_DATE_NU_I;

CREATE INDEX ADR.FUTURE_DISCHARGE_DATE_NU_I ON ADR.MILITARY_FUTURE_DISCHARGE
(FUTURE_DISCHARGE_DATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FUTURE_DISCHARGE_SRC_TYPE_PK;

CREATE UNIQUE INDEX ADR.FUTURE_DISCHARGE_SRC_TYPE_PK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(FUTURE_DISCHARGE_SRC_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FUTURE_DIS_SRC_TYPE_CD_UK;

CREATE UNIQUE INDEX ADR.FUTURE_DIS_SRC_TYPE_CD_UK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.FUTURE_DIS_SRC_TYPE_NM_UK;

CREATE UNIQUE INDEX ADR.FUTURE_DIS_SRC_TYPE_NM_UK ON ADR.FUTURE_DISCHARGE_SRC_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCDTRANSARCH_VCELIG_FK_I;

CREATE INDEX ADR.GEOCDTRANSARCH_VCELIG_FK_I ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCDTTNS_H_CRDTGEOTRNSID_NU_I;

CREATE INDEX ADR.GEOCDTTNS_H_CRDTGEOTRNSID_NU_I ON ADR.GEOCODE_TRANSMIT_H
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION GEOCDTRANS_P01
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.GEOCDTTNS_H_PERSONID_NU_I;

CREATE INDEX ADR.GEOCDTTNS_H_PERSONID_NU_I ON ADR.GEOCODE_TRANSMIT_H
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P1
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P2
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P3
    TABLESPACE L_INDEX_01,  
  PARTITION GEOCDTRNS_H_PERSONID_IDX_P4
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.GEOCDTTNS_H_VCELIG_NU_I;

CREATE INDEX ADR.GEOCDTTNS_H_VCELIG_NU_I ON ADR.GEOCODE_TRANSMIT_H
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCODETRANS_VCELIG_FK_I;

CREATE INDEX ADR.GEOCODETRANS_VCELIG_FK_I ON ADR.GEOCODE_TRANSMIT
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCODE_STAGE_PK;

CREATE UNIQUE INDEX ADR.GEOCODE_STAGE_PK ON ADR.GEOCODE_STAGE
(RECORD_CREATED_DATE, GEOCODE_STAGE_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_STAGE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.GEOCODE_STATION_H_PK;

CREATE UNIQUE INDEX ADR.GEOCODE_STATION_H_PK ON ADR.GEOCODE_STATION_H
(GEOCODE_STATION_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCODE_STATION_PK;

CREATE UNIQUE INDEX ADR.GEOCODE_STATION_PK ON ADR.GEOCODE_STATION
(GEOCODE_STATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCODE_ST_ID_NU_I;

CREATE INDEX ADR.GEOCODE_ST_ID_NU_I ON ADR.GEOCODE_STATION_H
(GEOCODE_STATION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.GEOCODE_TRANSMIT_ARCHIVE_PK;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_ARCHIVE_PK ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_TRANSMIT_ARCHIVE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.GEOCODE_TRANSMIT_H_PK_I;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_H_PK_I ON ADR.GEOCODE_TRANSMIT_H
(GEOCODE_TRANSMIT_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.GEOCODE_TRANSMIT_PK;

CREATE UNIQUE INDEX ADR.GEOCODE_TRANSMIT_PK ON ADR.GEOCODE_TRANSMIT
(RECORD_CREATED_DATE, GEOCODE_TRANSMIT_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION GEOCODE_TRANSMIT_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.GS_PERSONID_IDX;

CREATE INDEX ADR.GS_PERSONID_IDX ON ADR.GEOCODE_STAGE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GS_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GS_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.GTA_PERSONID_IDX;

CREATE INDEX ADR.GTA_PERSONID_IDX ON ADR.GEOCODE_TRANSMIT_ARCHIVE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GTA_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GTA_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.GT_PERSONID_IDX;

CREATE INDEX ADR.GT_PERSONID_IDX ON ADR.GEOCODE_TRANSMIT
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION GT_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION GT_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.HCPH_PK;

CREATE UNIQUE INDEX ADR.HCPH_PK ON ADR.HEALTH_CARE_PROVIDER_H
(HEALTH_CARE_PROVIDER_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HCP_PK;

CREATE UNIQUE INDEX ADR.HCP_PK ON ADR.HEALTH_CARE_PROVIDER
(HEALTH_CARE_PROVIDER_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPPH_PK;

CREATE UNIQUE INDEX ADR.HEALTHAPPH_PK ON ADR.HEALTH_BENEFITS_APPLICATION_H
(HEALTH_BENEFITS_APPLN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPPH_PRSNID_NU_I;

CREATE INDEX ADR.HEALTHAPPH_PRSNID_NU_I ON ADR.HEALTH_BENEFITS_APPLICATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPP_PK;

CREATE UNIQUE INDEX ADR.HEALTHAPP_PK ON ADR.HEALTH_BENEFITS_APPLICATION
(HEALTH_BENEFITS_APPLICATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPP_PRSN_FK_I;

CREATE INDEX ADR.HEALTHAPP_PRSN_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPP_STDHEALTH_FK_I;

CREATE INDEX ADR.HEALTHAPP_STDHEALTH_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_HEALTHBENEFITTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHAPP_STDINST_FK_I;

CREATE INDEX ADR.HEALTHAPP_STDINST_FK_I ON ADR.HEALTH_BENEFITS_APPLICATION
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTHPROFH_PRSNID_NU_I;

CREATE INDEX ADR.HEALTHPROFH_PRSNID_NU_I ON ADR.HEALTH_BENEFIT_PROFILE_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_H_PK;

CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_H_PK ON ADR.HEALTH_BENEFIT_PLAN_DESC_H
(HLTH_BEN_PLAN_DESC_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_PK;

CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_DESC_PK ON ADR.HEALTH_BENEFIT_PLAN_DESC
(HLTH_BEN_PLAN_DESC_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_H_PK;

CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_H_PK ON ADR.HEALTH_BENEFIT_PLAN_NAME_H
(HLTH_BEN_PLAN_NAME_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_PK;

CREATE UNIQUE INDEX ADR.HEALTH_BENEFIT_PLAN_NAME_PK ON ADR.HEALTH_BENEFIT_PLAN_NAME
(HLTH_BEN_PLAN_NAME_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HL7ARCLOG_HL7TRNLG_NU_I;

CREATE INDEX ADR.HL7ARCLOG_HL7TRNLG_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(REF_HL7_TRANSACTION_LOG_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (REF_HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7LOG_REFTRNID_FK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_REFTRNID_FK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7ARCLOG_PERSONID_NU_I;

CREATE INDEX ADR.HL7ARCLOG_PERSONID_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(PERSON_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION HL7_ARC_TRANSACTION_LOG_P01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARC_TRANSACTION_LOG_P08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_BTCHCNTLNO_NU_I;

CREATE INDEX ADR.HL7LOG_BTCHCNTLNO_NU_I ON ADR.HL7_TRANSACTION_LOG
(BATCH_CONTROL_NUMBER)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (BATCH_CONTROL_NUMBER) (  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_BTCHCNTLNO_NU_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_MSGCNTLNO_NU_I;

CREATE INDEX ADR.HL7LOG_MSGCNTLNO_NU_I ON ADR.HL7_TRANSACTION_LOG
(MESSAGE_CONTROL_NUMBER)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (MESSAGE_CONTROL_NUMBER) (  
  PARTITION HL7LOG_MSGCNTLNO_NU_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_MSGCNTLNO_NU_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_MSGTYPID_FK_I;

CREATE INDEX ADR.HL7LOG_MSGTYPID_FK_I ON ADR.HL7_TRANSACTION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_MSGTYPID_FK_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_MSGTYPID_FK_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_MSGTYPID_FK_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_MSGTYPID_FK_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_MSGTYPID_FK_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_MSGTYPID_FK_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_MSGTYPID_FK_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_MSGTYPID_FK_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_PERSONID_FK_I;

CREATE INDEX ADR.HL7LOG_PERSONID_FK_I ON ADR.HL7_TRANSACTION_LOG
(PERSON_ID)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION HL7LOG_PERSONID_FK_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_PERSONID_FK_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_PERSONID_FK_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_PERSONID_FK_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_PERSONID_FK_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_PERSONID_FK_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_PERSONID_FK_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_PERSONID_FK_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_PK;

CREATE INDEX ADR.HL7LOG_PK ON ADR.HL7_TRANSACTION_LOG
(HL7_TRANSACTION_LOG_ID)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7LOG_PK_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_PK_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_PK_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_PK_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_PK_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_PK_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_PK_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_PK_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_REFTRNID_FK_I;

CREATE INDEX ADR.HL7LOG_REFTRNID_FK_I ON ADR.HL7_TRANSACTION_LOG
(REF_HL7_TRANSACTION_LOG_ID)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (REF_HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7LOG_REFTRNID_FK_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_REFTRNID_FK_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_REFTRNID_FK_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_REFTRNID_FK_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_REFTRNID_FK_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_REFTRNID_FK_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_REFTRNID_FK_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_REFTRNID_FK_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7LOG_TRNDT_TRNTYP_NU_I;

CREATE INDEX ADR.HL7LOG_TRNDT_TRNTYP_NU_I ON ADR.HL7_TRANSACTION_LOG
(TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE M_DATA_01
  PCTFREE    10
  INITRANS   10
  MAXTRANS   255
  STORAGE    (
              INITIAL          128M
              NEXT             128M
              MINEXTENTS       1
              PCTINCREASE      0
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I01
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I02
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I03
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I04
    TABLESPACE L_INDEX_02_P04,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I05
    TABLESPACE L_INDEX_02_P01,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I06
    TABLESPACE L_INDEX_02_P02,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I07
    TABLESPACE L_INDEX_02_P03,  
  PARTITION HL7LOG_TRNDT_TRNTYP_NU_I08
    TABLESPACE L_INDEX_02_P04
)
NOPARALLEL;
DROP INDEX ADR.HL7_ARCLOG_BTCHCNTLNO_NU_I;

CREATE INDEX ADR.HL7_ARCLOG_BTCHCNTLNO_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(BATCH_CONTROL_NUMBER)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (BATCH_CONTROL_NUMBER) (  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_BTCHCNTLNO_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7_ARCLOG_MSGCNTLNO_NU_I;

CREATE INDEX ADR.HL7_ARCLOG_MSGCNTLNO_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(MESSAGE_CONTROL_NUMBER)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (MESSAGE_CONTROL_NUMBER) (  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGCNTLNO_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7_ARCLOG_MSGTYPID_FK_I;

CREATE INDEX ADR.HL7_ARCLOG_MSGTYPID_FK_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_MSGTYPID_FK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7_ARCLOG_PK;

CREATE INDEX ADR.HL7_ARCLOG_PK ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(HL7_TRANSACTION_LOG_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (HL7_TRANSACTION_LOG_ID) (  
  PARTITION HL7_ARCLOG_PK_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7_ARCLOG_PK_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7_ARCLOG_TRNDT_TRNTYP_NU_I;

CREATE INDEX ADR.HL7_ARCLOG_TRNDT_TRNTYP_NU_I ON ADR.HL7_ARCHIVE_TRANSACTION_LOG
(TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (TRANSMISSION_DATE, MESSAGE_TRANSMISSION_TYPE_ID) (  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I01
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I02
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I03
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I04
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I05
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I06
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I07
    TABLESPACE L_INDEX_03,  
  PARTITION HL7LOG_ARC_TRNDT_TRNTYP_NU_I08
    TABLESPACE L_INDEX_03
)
NOPARALLEL;
DROP INDEX ADR.HL7_STATS_MV_NU_I;

CREATE INDEX ADR.HL7_STATS_MV_NU_I ON ADR.HL7_STATS_MV
(MESSAGE_TRANSMISSION_TYPE_ID, STD_INSTITUTION_ID, RECORD_CREATED_DATE)
  TABLESPACE M_INDEX_02_P01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION HL7STATSMV_P01
    LOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_02_P01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE M_INDEX_02_P01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.HLTBNFPLN_HLTBNFPRF_FK_I;

CREATE INDEX ADR.HLTBNFPLN_HLTBNFPRF_FK_I ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTBNFPRF_PRSN_FK_I;

CREATE INDEX ADR.HLTBNFPRF_PRSN_FK_I ON ADR.HEALTH_BENEFIT_PROFILE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLANDET_HBPCCD_UI;

CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_HBPCCD_UI ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HLTH_BEN_PLAN_COV_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLANDET_HBPCD_UI;

CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_HBPCD_UI ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HLTH_BEN_PLAN_COV_CODE, HLTH_BEN_PLAN_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLANDET_PK;

CREATE UNIQUE INDEX ADR.HLTHBENPLANDET_PK ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
(HEALTH_BENEFIT_PLAN_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLNDEFNM_UI;

CREATE UNIQUE INDEX ADR.HLTHBENPLNDEFNM_UI ON ADR.HEALTH_BENEFIT_PLAN_NAME
(HLTH_BEN_PLAN_NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLNH_BENPLANID_NU_I;

CREATE INDEX ADR.HLTHBENPLNH_BENPLANID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.HLTHBENPLNH_BENPROFID_NU_I;

CREATE INDEX ADR.HLTHBENPLNH_BENPROFID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.HLTHBENPLNH_PK;

CREATE UNIQUE INDEX ADR.HLTHBENPLNH_PK ON ADR.HEALTH_BENEFIT_PLAN_H
(HEALTH_BENEFIT_PLAN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPLNH_SHBPID_NU_I;

CREATE INDEX ADR.HLTHBENPLNH_SHBPID_NU_I ON ADR.HEALTH_BENEFIT_PLAN_H
(STD_HEALTHBENEFITPLAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.HLTHBENPLN_PK;

CREATE UNIQUE INDEX ADR.HLTHBENPLN_PK ON ADR.HEALTH_BENEFIT_PLAN
(HEALTH_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPRFH_PK;

CREATE UNIQUE INDEX ADR.HLTHBENPRFH_PK ON ADR.HEALTH_BENEFIT_PROFILE_H
(HEALTH_BENEFIT_PROFILE_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTHBENPRF_PK;

CREATE UNIQUE INDEX ADR.HLTHBENPRF_PK ON ADR.HEALTH_BENEFIT_PROFILE
(HEALTH_BENEFIT_PROFILE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HLTH_BEN_PLAN_DETAIL_H_PK;

CREATE UNIQUE INDEX ADR.HLTH_BEN_PLAN_DETAIL_H_PK ON ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
(HEALTH_BENEFIT_PLAN_DET_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDBATREQH_PK;

CREATE UNIQUE INDEX ADR.HNDBATREQH_PK ON ADR.HANDBOOK_BATCH_REQUEST_H
(HANDBOOK_BATCH_REQUEST_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDBATREQ_PK;

CREATE UNIQUE INDEX ADR.HNDBATREQ_PK ON ADR.HANDBOOK_BATCH_REQUEST
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDBATREQ_STDHDBRELCNT_FK_I;

CREATE INDEX ADR.HNDBATREQ_STDHDBRELCNT_FK_I ON ADR.HANDBOOK_BATCH_REQUEST
(STD_HANDBOOKRELEASECNTL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDBATREQ_STDHNDREQSTA_FK_I;

CREATE INDEX ADR.HNDBATREQ_STDHNDREQSTA_FK_I ON ADR.HANDBOOK_BATCH_REQUEST
(STD_HANDBOOKBATCHREQUESTSTA_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDBK_MAIL_QUEID_NU;

CREATE INDEX ADR.HNDBK_MAIL_QUEID_NU ON ADR.HANDBOOK_MAIL_QUEUE_H
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDDOC_HNDMALSTA_FK_I;

CREATE INDEX ADR.HNDDOC_HNDMALSTA_FK_I ON ADR.HANDBOOK_DOCUMENT
(HANDBOOK_MAIL_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDDOC_PK;

CREATE UNIQUE INDEX ADR.HNDDOC_PK ON ADR.HANDBOOK_DOCUMENT
(HANDBOOK_DOCUMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALQUEH_PK;

CREATE UNIQUE INDEX ADR.HNDMALQUEH_PK ON ADR.HANDBOOK_MAIL_QUEUE_H
(HANDBOOK_MAIL_QUEUE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALQUE_HNDBATREQ_FK;

CREATE INDEX ADR.HNDMALQUE_HNDBATREQ_FK ON ADR.HANDBOOK_MAIL_QUEUE
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALQUE_PER_FK;

CREATE INDEX ADR.HNDMALQUE_PER_FK ON ADR.HANDBOOK_MAIL_QUEUE
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALQUE_PK;

CREATE UNIQUE INDEX ADR.HNDMALQUE_PK ON ADR.HANDBOOK_MAIL_QUEUE
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALQUE_STDHNDBKRELCNT_FK;

CREATE INDEX ADR.HNDMALQUE_STDHNDBKRELCNT_FK ON ADR.HANDBOOK_MAIL_QUEUE
(STD_HANDBOOKRELEASECNTL_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTAH_CMSFLGENDT_NU_I;

CREATE INDEX ADR.HNDMALSTAH_CMSFLGENDT_NU_I ON ADR.HANDBOOK_MAIL_STATUS_H
(CMS_FILE_GENERATED_DATE, STD_HANDBOOKMAILSTATTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTAH_HNDMALQUE_NU_I;

CREATE INDEX ADR.HNDMALSTAH_HNDMALQUE_NU_I ON ADR.HANDBOOK_MAIL_STATUS_H
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTAH_PK;

CREATE UNIQUE INDEX ADR.HNDMALSTAH_PK ON ADR.HANDBOOK_MAIL_STATUS_H
(HANDBOOK_MAIL_STATUS_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTA_HNDMALQUE_FK;

CREATE INDEX ADR.HNDMALSTA_HNDMALQUE_FK ON ADR.HANDBOOK_MAIL_STATUS
(HANDBOOK_MAIL_QUEUE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTA_PK;

CREATE UNIQUE INDEX ADR.HNDMALSTA_PK ON ADR.HANDBOOK_MAIL_STATUS
(HANDBOOK_MAIL_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTA_STDCOMREJREATYP_FK;

CREATE INDEX ADR.HNDMALSTA_STDCOMREJREATYP_FK ON ADR.HANDBOOK_MAIL_STATUS
(STD_COMREJECTREASONTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDMALSTA_STDHNDBKMALSTATYP_FK;

CREATE INDEX ADR.HNDMALSTA_STDHNDBKMALSTATYP_FK ON ADR.HANDBOOK_MAIL_STATUS
(STD_HANDBOOKMAILSTATTYPE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDREQVETH_PK;

CREATE UNIQUE INDEX ADR.HNDREQVETH_PK ON ADR.HANDBOOK_REQUEST_VETERAN_H
(HANDBOOK_REQUEST_VETERAN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDREQVET_HNDBCHREQ_FK_I;

CREATE INDEX ADR.HNDREQVET_HNDBCHREQ_FK_I ON ADR.HANDBOOK_REQUEST_VETERAN
(HANDBOOK_BATCH_REQUEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDREQVET_PK;

CREATE UNIQUE INDEX ADR.HNDREQVET_PK ON ADR.HANDBOOK_REQUEST_VETERAN
(HANDBOOK_REQUEST_VETERAN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.HNDREQVET_PRSN_FK_I;

CREATE INDEX ADR.HNDREQVET_PRSN_FK_I ON ADR.HANDBOOK_REQUEST_VETERAN
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_JOB_GROUP;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_GROUP ON ADR.QRTZ_FIRED_TRIGGERS
(JOB_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_JOB_NAME;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_JOB_REQ_RECOVERY;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_REQ_RECOVERY ON ADR.QRTZ_FIRED_TRIGGERS
(REQUESTS_RECOVERY)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_JOB_STATEFUL;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_STATEFUL ON ADR.QRTZ_FIRED_TRIGGERS
(IS_STATEFUL)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_TRIG_GROUP;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_GROUP ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_TRIG_INST_NAME;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_INST_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(INSTANCE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_TRIG_NAME;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_TRIG_NM_GP;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_NM_GP ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_FT_TRIG_VOLATILE;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_VOLATILE ON ADR.QRTZ_FIRED_TRIGGERS
(IS_VOLATILE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_J_REQ_RECOVERY;

CREATE INDEX ADR.IDX_QRTZ_J_REQ_RECOVERY ON ADR.QRTZ_JOB_DETAILS
(REQUESTS_RECOVERY)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_T_NEXT_FIRE_TIME;

CREATE INDEX ADR.IDX_QRTZ_T_NEXT_FIRE_TIME ON ADR.QRTZ_TRIGGERS
(NEXT_FIRE_TIME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_T_NFT_ST;

CREATE INDEX ADR.IDX_QRTZ_T_NFT_ST ON ADR.QRTZ_TRIGGERS
(NEXT_FIRE_TIME, TRIGGER_STATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_T_STATE;

CREATE INDEX ADR.IDX_QRTZ_T_STATE ON ADR.QRTZ_TRIGGERS
(TRIGGER_STATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IDX_QRTZ_T_VOLATILE;

CREATE INDEX ADR.IDX_QRTZ_T_VOLATILE ON ADR.QRTZ_TRIGGERS
(IS_VOLATILE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTH_INCMTSTID_NU_I;

CREATE INDEX ADR.INCMTSTDTH_INCMTSTID_NU_I ON ADR.INCOME_TEST_DETAIL_H
(INCOME_TEST_ID, TEST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTH_PK;

CREATE UNIQUE INDEX ADR.INCMTSTDTH_PK ON ADR.INCOME_TEST_DETAIL_H
(INCOME_TEST_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTL_INCMTST_FK_I;

CREATE INDEX ADR.INCMTSTDTL_INCMTST_FK_I ON ADR.INCOME_TEST_DETAIL
(INCOME_TEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTL_MTSTATTYP_FK_I;

CREATE INDEX ADR.INCMTSTDTL_MTSTATTYP_FK_I ON ADR.INCOME_TEST_DETAIL
(TEST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTL_MTSTATTYP_H_FK_I;

CREATE INDEX ADR.INCMTSTDTL_MTSTATTYP_H_FK_I ON ADR.INCOME_TEST_DETAIL
(TEST_DETMND_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTL_PK;

CREATE UNIQUE INDEX ADR.INCMTSTDTL_PK ON ADR.INCOME_TEST_DETAIL
(INCOME_TEST_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTDTL_STD_INCMTSTYP_FK_I;

CREATE INDEX ADR.INCMTSTDTL_STD_INCMTSTYP_FK_I ON ADR.INCOME_TEST_DETAIL
(INCOME_TEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTH_PK;

CREATE UNIQUE INDEX ADR.INCMTSTH_PK ON ADR.INCOME_TEST_H
(INCOME_TEST_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTSTH_PRSNID_NU_I;

CREATE INDEX ADR.INCMTSTH_PRSNID_NU_I ON ADR.INCOME_TEST_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_PK;

CREATE UNIQUE INDEX ADR.INCMTST_PK ON ADR.INCOME_TEST
(INCOME_TEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_PRSN_FK_I;

CREATE INDEX ADR.INCMTST_PRSN_FK_I ON ADR.INCOME_TEST
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STDINST_FK2_I;

CREATE INDEX ADR.INCMTST_STDINST_FK2_I ON ADR.INCOME_TEST
(HARDSHIP_REVIEW_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STDINST_FK_I;

CREATE INDEX ADR.INCMTST_STDINST_FK_I ON ADR.INCOME_TEST
(SITE_CONDUCTING_TEST_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STD_INCMTSTSRC_FK_I;

CREATE INDEX ADR.INCMTST_STD_INCMTSTSRC_FK_I ON ADR.INCOME_TEST
(INCOME_TEST_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STD_INCMTSTYP_FK_I;

CREATE INDEX ADR.INCMTST_STD_INCMTSTYP_FK_I ON ADR.INCOME_TEST
(INCOME_TEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STD_MNSTSTST_FK2_I;

CREATE INDEX ADR.INCMTST_STD_MNSTSTST_FK2_I ON ADR.INCOME_TEST
(INCOME_VERIFY_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STD_MNSTSTST_FK_I;

CREATE INDEX ADR.INCMTST_STD_MNSTSTST_FK_I ON ADR.INCOME_TEST
(MEANS_TEST_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCMTST_STD_MTNOTREQRS_FK_I;

CREATE INDEX ADR.INCMTST_STD_MTNOTREQRS_FK_I ON ADR.INCOME_TEST
(MT_NOT_REQD_RSN_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCOMPRULE_PK;

CREATE UNIQUE INDEX ADR.INCOMPRULE_PK ON ADR.INCOMPETENT_RULING
(INCOMPETENT_RULING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCOMPRULE_PRSN_FK_I;

CREATE INDEX ADR.INCOMPRULE_PRSN_FK_I ON ADR.INCOMPETENT_RULING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCOMPRULH_PK;

CREATE UNIQUE INDEX ADR.INCOMPRULH_PK ON ADR.INCOMPETENT_RULING_H
(INCOMPETENT_RULING_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INCOMPRULH_PRSNID_NU_I;

CREATE INDEX ADR.INCOMPRULH_PRSNID_NU_I ON ADR.INCOMPETENT_RULING_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INELIGBRLG_PK;

CREATE UNIQUE INDEX ADR.INELIGBRLG_PK ON ADR.INELIGIBLE_RULING
(INELIGIBLE_RULING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INELIGBRLG_PRSN_FK_I;

CREATE INDEX ADR.INELIGBRLG_PRSN_FK_I ON ADR.INELIGIBLE_RULING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INELIGBRLG_STDINST_FK_I;

CREATE INDEX ADR.INELIGBRLG_STDINST_FK_I ON ADR.INELIGIBLE_RULING
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INELIGBRLH_PK;

CREATE UNIQUE INDEX ADR.INELIGBRLH_PK ON ADR.INELIGIBLE_RULING_H
(INELIGIBLE_RULING_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INELIGBRLH_PRSNID_NU_I;

CREATE INDEX ADR.INELIGBRLH_PRSNID_NU_I ON ADR.INELIGIBLE_RULING_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INPROCFNCL_PK;

CREATE UNIQUE INDEX ADR.INPROCFNCL_PK ON ADR.IN_PROCESS_FINANCIALS
(IN_PROCESS_FINANCIAL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INPROCFNCL_PRSN_FK_I;

CREATE INDEX ADR.INPROCFNCL_PRSN_FK_I ON ADR.IN_PROCESS_FINANCIALS
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_INSRHLDRTYPE_FK_I;

CREATE INDEX ADR.INSR_STD_INSRHLDRTYPE_FK_I ON ADR.INSURANCE
(POLICY_HOLDER_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_INSRPLANTYP_FK_I;

CREATE INDEX ADR.INSR_STD_INSRPLANTYP_FK_I ON ADR.INSURANCE
(INSURANCE_PLAN_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_INSRREP_FK_I;

CREATE INDEX ADR.INSR_STD_INSRREP_FK_I ON ADR.INSURANCE
(INSURANCE_RPT_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_INST_FK_I;

CREATE INDEX ADR.INSR_STD_INST_FK_I ON ADR.INSURANCE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_INSURANCEMAP_FK_I;

CREATE INDEX ADR.INSR_STD_INSURANCEMAP_FK_I ON ADR.INSURANCE
(INSURANCE_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_NOSTUPLDRSN_FK_I;

CREATE INDEX ADR.INSR_STD_NOSTUPLDRSN_FK_I ON ADR.INSURANCE
(SITE_NO_UPLOAD_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSR_STD_STUPLDSTATUS_FK_I;

CREATE INDEX ADR.INSR_STD_STUPLDSTATUS_FK_I ON ADR.INSURANCE
(SITE_UPLOAD_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSURANCEH_PK;

CREATE UNIQUE INDEX ADR.INSURANCEH_PK ON ADR.INSURANCE_H
(INSURANCE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSURANCEH_PRSNID_NU_I;

CREATE INDEX ADR.INSURANCEH_PRSNID_NU_I ON ADR.INSURANCE_H
(PERSON_ID, INSURANCE_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSURANCE_PK;

CREATE UNIQUE INDEX ADR.INSURANCE_PK ON ADR.INSURANCE
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.INSURANCE_PRSN_FK_I;

CREATE INDEX ADR.INSURANCE_PRSN_FK_I ON ADR.INSURANCE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRSTRNSDAT_IRSTRNSLG_FK_I;

CREATE INDEX ADR.IRSTRNSDAT_IRSTRNSLG_FK_I ON ADR.IRS_TRANSMISSION_DATA
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRSTRNSLGDET_IEN_NU_I;

CREATE INDEX ADR.IRSTRNSLGDET_IEN_NU_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(IEN)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRSTRNSLGDET_IRSTRNSLG_FK_I;

CREATE INDEX ADR.IRSTRNSLGDET_IRSTRNSLG_FK_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRSTRNSLGDET_PERS_FK_I;

CREATE INDEX ADR.IRSTRNSLGDET_PERS_FK_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRSTRNSLG_TRNSSTAT_FK_I;

CREATE INDEX ADR.IRSTRNSLG_TRNSSTAT_FK_I ON ADR.IRS_TRANSMISSION_LOG
(TRANSMISSION_STATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRS_TRANSMISSION_DATA_ID_PK;

CREATE UNIQUE INDEX ADR.IRS_TRANSMISSION_DATA_ID_PK ON ADR.IRS_TRANSMISSION_DATA
(IRS_TRANSMISSION_DATA_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRS_TRANSMISSION_LOG_ID_PK;

CREATE UNIQUE INDEX ADR.IRS_TRANSMISSION_LOG_ID_PK ON ADR.IRS_TRANSMISSION_LOG
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IRS_TRANS_LOG_DET_ID_PK;

CREATE UNIQUE INDEX ADR.IRS_TRANS_LOG_DET_ID_PK ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(IRS_TRANSMISSION_LOG_DETAIL_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ITL_RECEIPT_ID_NU_I;

CREATE INDEX ADR.ITL_RECEIPT_ID_NU_I ON ADR.IRS_TRANSMISSION_LOG
(RECEIPT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ITL_YEAR_NU_I;

CREATE INDEX ADR.ITL_YEAR_NU_I ON ADR.IRS_TRANSMISSION_LOG
(YEAR)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGEXDTL_IVMMGEX_FK_I;

CREATE INDEX ADR.IVMMGEXDTL_IVMMGEX_FK_I ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGEXDTL_PK;

CREATE UNIQUE INDEX ADR.IVMMGEXDTL_PK ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGEX_PK;

CREATE UNIQUE INDEX ADR.IVMMGEX_PK ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGEX_STD_IVMMGRTYP_FK_I;

CREATE INDEX ADR.IVMMGEX_STD_IVMMGRTYP_FK_I ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRTARC_PK;

CREATE UNIQUE INDEX ADR.IVMMGRTARC_PK ON ADR.IVM_MIGRATE_ARCHIVE
(IVM_MIGRATE_ARCHIVE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (IVM_MIGRATE_ARCHIVE_ID) (  
  PARTITION IVMMGRTARC_IDX_P001
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P002
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P003
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P004
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P005
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P006
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P007
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P008
    TABLESPACE L_INDEX_03
)
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.IVMMGRT_LGCYICN_NU_I;

CREATE INDEX ADR.IVMMGRT_LGCYICN_NU_I ON ADR.IVM_MIGRATE
(LEGACY_ICN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRT_PK;

CREATE UNIQUE INDEX ADR.IVMMGRT_PK ON ADR.IVM_MIGRATE
(IVM_MIGRATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRT_PRSN_FK_I;

CREATE INDEX ADR.IVMMGRT_PRSN_FK_I ON ADR.IVM_MIGRATE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRT_PRSN_INCYR_REMIG_NU_I;

CREATE INDEX ADR.IVMMGRT_PRSN_INCYR_REMIG_NU_I ON ADR.IVM_MIGRATE
(PERSON_ID, INCOME_YEAR, REMIGRATE_FLAG)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRT_RCDCRTDT_NU_I;

CREATE INDEX ADR.IVMMGRT_RCDCRTDT_NU_I ON ADR.IVM_MIGRATE
(RECORD_CREATED_DATE)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMGRT_STDMSGSTA_NU_I;

CREATE INDEX ADR.IVMMGRT_STDMSGSTA_NU_I ON ADR.IVM_MIGRATE
(STD_MESSAGESTATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IVMMIGSTAT_PK;

CREATE UNIQUE INDEX ADR.IVMMIGSTAT_PK ON ADR.IVM_MIGRATE_STATISTICS
(IVM_MIGRATE_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP51;

CREATE INDEX ADR.IX_RELATIONSHIP51 ON ADR.PENSION
(PENSION_AWARD_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP52;

CREATE INDEX ADR.IX_RELATIONSHIP52 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID1)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP53;

CREATE INDEX ADR.IX_RELATIONSHIP53 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID2)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP54;

CREATE INDEX ADR.IX_RELATIONSHIP54 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID3)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP55;

CREATE INDEX ADR.IX_RELATIONSHIP55 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID4)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP59;

CREATE INDEX ADR.IX_RELATIONSHIP59 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(HEALTH_CARE_PROVIDER_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP60;

CREATE INDEX ADR.IX_RELATIONSHIP60 ON ADR.PREFERRED_FACILITY
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP65;

CREATE INDEX ADR.IX_RELATIONSHIP65 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP69;

CREATE INDEX ADR.IX_RELATIONSHIP69 ON ADR.HANDBOOK_REQUEST_VETERAN_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RELATIONSHIP74;

CREATE INDEX ADR.IX_RELATIONSHIP74 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(STD_TEAM_PURPOSE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.IX_RPT_SCHED_REP_RPT_FORM_TYP;

CREATE INDEX ADR.IX_RPT_SCHED_REP_RPT_FORM_TYP ON ADR.RPT_FORM_TYPE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.I_MLOG$_HL7_TRANSACTION_LO;

CREATE INDEX ADR.I_MLOG$_HL7_TRANSACTION_LO ON ADR.MLOG$_HL7_TRANSACTION_LOG
(XID$$)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JCONFIG_PK;

CREATE UNIQUE INDEX ADR.JCONFIG_PK ON ADR.JOB_CONFIG
(JOB_CONFIG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JOB_CONFIG_GRPNAME_I;

CREATE INDEX ADR.JOB_CONFIG_GRPNAME_I ON ADR.JOB_CONFIG
(JOB_GROUP_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JOB_CONFIG_NAME_I;

CREATE INDEX ADR.JOB_CONFIG_NAME_I ON ADR.JOB_CONFIG
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JOB_RESULT_GRPNAME_I;

CREATE INDEX ADR.JOB_RESULT_GRPNAME_I ON ADR.JOB_RESULT
(JOB_GROUP_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JOB_RESULT_NAME_I;

CREATE INDEX ADR.JOB_RESULT_NAME_I ON ADR.JOB_RESULT
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JOB_RESULT_STATUS_I;

CREATE INDEX ADR.JOB_RESULT_STATUS_I ON ADR.JOB_RESULT
(JOB_STATUS_CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.JRESULT_PK;

CREATE UNIQUE INDEX ADR.JRESULT_PK ON ADR.JOB_RESULT
(JOB_RESULT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUAL_OVERRIDE_H_PK;

CREATE UNIQUE INDEX ADR.MANUAL_OVERRIDE_H_PK ON ADR.MANUAL_OVERRIDE_H
(MANUAL_OVERRIDE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUAL_OVERRIDE_PK;

CREATE UNIQUE INDEX ADR.MANUAL_OVERRIDE_PK ON ADR.MANUAL_OVERRIDE
(MANUAL_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_NM_UK;

CREATE UNIQUE INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_NM_UK ON ADR.MANUAL_OVERRIDE_RSN_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_PK;

CREATE UNIQUE INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_PK ON ADR.MANUAL_OVERRIDE_RSN_TYPE
(MANUAL_OVERRIDE_RSN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_UK;

CREATE UNIQUE INDEX ADR.MANUAL_OVERRIDE_RSN_TYPE_UK ON ADR.MANUAL_OVERRIDE_RSN_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MANUOVERRIDE_VCESTATTYPE_FK_I;

CREATE INDEX ADR.MANUOVERRIDE_VCESTATTYPE_FK_I ON ADR.MANUAL_OVERRIDE
(VCESTATUSTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEC_PERIOD_ID_PK;

CREATE UNIQUE INDEX ADR.MEC_PERIOD_ID_PK ON ADR.MEC_PERIOD_NEW
(MEC_PERIOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEC_PERIOD_N_END_DATE_NU_I;

CREATE INDEX ADR.MEC_PERIOD_N_END_DATE_NU_I ON ADR.MEC_PERIOD_NEW
(MEC_END_DATE)
NOLOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEC_PERIOD_N_PERSON_FK_I;

CREATE INDEX ADR.MEC_PERIOD_N_PERSON_FK_I ON ADR.MEC_PERIOD_NEW
(PERSON_ID)
NOLOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEDICAIDH_PK;

CREATE UNIQUE INDEX ADR.MEDICAIDH_PK ON ADR.MEDICAID_FACTOR_H
(MEDICAID_FACTOR_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEDICAIDH_PRSNID_NU_I;

CREATE INDEX ADR.MEDICAIDH_PRSNID_NU_I ON ADR.MEDICAID_FACTOR_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEDICAID_PK;

CREATE UNIQUE INDEX ADR.MEDICAID_PK ON ADR.MEDICAID_FACTOR
(MEDICAID_FACTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MEDICAID_PRSN_FK_I;

CREATE INDEX ADR.MEDICAID_PRSN_FK_I ON ADR.MEDICAID_FACTOR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILITARY_FUTURE_DIS_H_PK;

CREATE UNIQUE INDEX ADR.MILITARY_FUTURE_DIS_H_PK ON ADR.MILITARY_FUTURE_DISCHARGE_H
(MILITARY_FUTURE_DISCHARGE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILITARY_FUTURE_DIS_PK;

CREATE UNIQUE INDEX ADR.MILITARY_FUTURE_DIS_PK ON ADR.MILITARY_FUTURE_DISCHARGE
(MILITARY_FUTURE_DISCHARGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPH_MILSRVC_NU_I;

CREATE INDEX ADR.MILSRVCEPH_MILSRVC_NU_I ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPH_PK;

CREATE UNIQUE INDEX ADR.MILSRVCEPH_PK ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPS_MILSRVC_FK_I;

CREATE INDEX ADR.MILSRVCEPS_MILSRVC_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPS_MILSVCNBR_FB_I;

CREATE INDEX ADR.MILSRVCEPS_MILSVCNBR_FB_I ON ADR.MILITARY_SERVICE_EPISODE
(UPPER("MILITARY_SERVICE_NUMBER"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.MILSRVCEPS_PK;

CREATE UNIQUE INDEX ADR.MILSRVCEPS_PK ON ADR.MILITARY_SERVICE_EPISODE
(MILITARY_SERVICE_EPISODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPS_STDMSVCMPT_FK_I;

CREATE INDEX ADR.MILSRVCEPS_STDMSVCMPT_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICECOMPONENTTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPS_STD_SVCBRNCH_FK_I;

CREATE INDEX ADR.MILSRVCEPS_STD_SVCBRNCH_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICE_BRANCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCEPS_STD_SVCDSCHRG_FK_I;

CREATE INDEX ADR.MILSRVCEPS_STD_SVCDSCHRG_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICE_DISCHARGE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCH_PK;

CREATE UNIQUE INDEX ADR.MILSRVCH_PK ON ADR.MILITARY_SERVICE_H
(MILITARY_SERVICE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVCH_PRSNID_NU_I;

CREATE INDEX ADR.MILSRVCH_PRSNID_NU_I ON ADR.MILITARY_SERVICE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVC_PK;

CREATE UNIQUE INDEX ADR.MILSRVC_PK ON ADR.MILITARY_SERVICE
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVC_PRSN_FK_I;

CREATE INDEX ADR.MILSRVC_PRSN_FK_I ON ADR.MILITARY_SERVICE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVC_STDINST_FK_I;

CREATE INDEX ADR.MILSRVC_STDINST_FK_I ON ADR.MILITARY_SERVICE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVC_STDPERSRVC_FK_I;

CREATE INDEX ADR.MILSRVC_STDPERSRVC_FK_I ON ADR.MILITARY_SERVICE
(STD_PERIODOFSERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MILSRVC_STD_FLPNOVTRN_FK_I;

CREATE INDEX ADR.MILSRVC_STD_FLPNOVTRN_FK_I ON ADR.MILITARY_SERVICE
(FILIPINO_VET_DOC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MLOG$_HL7LOG_ID_NU_I;

CREATE INDEX ADR.MLOG$_HL7LOG_ID_NU_I ON ADR.MLOG$_HL7_TRANSACTION_LOG
(HL7_TRANSACTION_LOG_ID)
LOGGING
TABLESPACE M_INDEX_02_P01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MLOG$_HL7LOG_SNAPTIME_NU_I;

CREATE INDEX ADR.MLOG$_HL7LOG_SNAPTIME_NU_I ON ADR.MLOG$_HL7_TRANSACTION_LOG
(SNAPTIME$$)
LOGGING
TABLESPACE M_INDEX_02_P01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MOH_H_PK;

CREATE UNIQUE INDEX ADR.MOH_H_PK ON ADR.MEDAL_OF_HONOR_H
(MEDAL_OF_HONOR_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MOH_PERSON_FK_I;

CREATE INDEX ADR.MOH_PERSON_FK_I ON ADR.MEDAL_OF_HONOR
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MOH_PK;

CREATE UNIQUE INDEX ADR.MOH_PK ON ADR.MEDAL_OF_HONOR
(MEDAL_OF_HONOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBENH_PK;

CREATE UNIQUE INDEX ADR.MONEYBENH_PK ON ADR.MONETARY_BENEFIT_H
(MONETARY_BENEFIT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBENH_PRSNID_NU_I;

CREATE INDEX ADR.MONEYBENH_PRSNID_NU_I ON ADR.MONETARY_BENEFIT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBEN_PK;

CREATE UNIQUE INDEX ADR.MONEYBEN_PK ON ADR.MONETARY_BENEFIT
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBEN_PRSN_FK_I;

CREATE INDEX ADR.MONEYBEN_PRSN_FK_I ON ADR.MONETARY_BENEFIT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTLH_MONEYBEN_NU_I;

CREATE INDEX ADR.MONEYBNDTLH_MONEYBEN_NU_I ON ADR.MONETARY_BENEFIT_DETAIL_H
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTLH_PK;

CREATE UNIQUE INDEX ADR.MONEYBNDTLH_PK ON ADR.MONETARY_BENEFIT_DETAIL_H
(MONETARY_BENEFIT_DETAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTL_MONEYBEN_FK_I;

CREATE INDEX ADR.MONEYBNDTL_MONEYBEN_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTL_PK;

CREATE UNIQUE INDEX ADR.MONEYBNDTL_PK ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTL_STDYESNO_FK_I;

CREATE INDEX ADR.MONEYBNDTL_STDYESNO_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.MONEYBNDTL_STD_MNTRYBNTYP_FK_I;

CREATE INDEX ADR.MONEYBNDTL_STD_MNTRYBNTYP_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.NAME_UK;

CREATE UNIQUE INDEX ADR.NAME_UK ON ADR.TRANSMISSION_TYPE
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PATPRVASGNH_PK;

CREATE UNIQUE INDEX ADR.PATPRVASGNH_PK ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H
(PATIENT_PROVIDER_ASSIGN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PATPRVASGN_PK;

CREATE UNIQUE INDEX ADR.PATPRVASGN_PK ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(PATIENT_PROVIDER_ASSIGNMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PCPSTAGE_PERSONID_FK_I;

CREATE INDEX ADR.PCPSTAGE_PERSONID_FK_I ON ADR.PCP_STAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PCP_STAGE_PK;

CREATE UNIQUE INDEX ADR.PCP_STAGE_PK ON ADR.PCP_STAGE
(PCP_STAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERMSETH_PK;

CREATE UNIQUE INDEX ADR.PERMSETH_PK ON ADR.PERMISSION_SET_H
(PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERMSET_PK;

CREATE UNIQUE INDEX ADR.PERMSET_PK ON ADR.PERMISSION_SET
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERMSET_U_CODE_UK;

CREATE UNIQUE INDEX ADR.PERMSET_U_CODE_UK ON ADR.PERMISSION_SET
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERSON_ID_FK_I;

CREATE INDEX ADR.PERSON_ID_FK_I ON ADR.CORRESPONDENCE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERSON_ID_MAX_PK;

CREATE UNIQUE INDEX ADR.PERSON_ID_MAX_PK ON ADR.MEC_PERIOD_LAST_HIST_NEW
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK;

CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK ON ADR.PERSON_PREFERRED_LANGUAGE_H
(PERSON_PREFERRED_LANG_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK;

CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_PREFERRED_LANGUAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONEH_PK;

CREATE UNIQUE INDEX ADR.PHONEH_PK ON ADR.PHONE_H
(PHONE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONEH_PRSNID_NU_I;

CREATE INDEX ADR.PHONEH_PRSNID_NU_I ON ADR.PHONE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_INSURANCE_FK_I;

CREATE INDEX ADR.PHONE_INSURANCE_FK_I ON ADR.PHONE
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_PK;

CREATE UNIQUE INDEX ADR.PHONE_PK ON ADR.PHONE
(PHONE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_PRSNREL_FK_I;

CREATE INDEX ADR.PHONE_PRSNREL_FK_I ON ADR.PHONE
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_PRSN_FK_I;

CREATE INDEX ADR.PHONE_PRSN_FK_I ON ADR.PHONE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_STDINST_FK_I;

CREATE INDEX ADR.PHONE_STDINST_FK_I ON ADR.PHONE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_STD_PHCHGSRC_FK_I;

CREATE INDEX ADR.PHONE_STD_PHCHGSRC_FK_I ON ADR.PHONE
(PHONE_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHONE_STD_PHONECTACTTYP_FK_I;

CREATE INDEX ADR.PHONE_STD_PHONECTACTTYP_FK_I ON ADR.PHONE
(PHONE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTLH_PK;

CREATE UNIQUE INDEX ADR.PHREGDTLH_PK ON ADR.PH_REGISTRY_DETAIL_H
(PH_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTLH_PRPLHRTREG_NU_I;

CREATE INDEX ADR.PHREGDTLH_PRPLHRTREG_NU_I ON ADR.PH_REGISTRY_DETAIL_H
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTL_PK;

CREATE UNIQUE INDEX ADR.PHREGDTL_PK ON ADR.PH_REGISTRY_DETAIL
(PH_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTL_PRPLHRTREG_FK_I;

CREATE INDEX ADR.PHREGDTL_PRPLHRTREG_FK_I ON ADR.PH_REGISTRY_DETAIL
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTL_STD_DCRNDOCTYP_FK_I;

CREATE INDEX ADR.PHREGDTL_STD_DCRNDOCTYP_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PHREGDTL_STD_PHDATASRC_FK_I;

CREATE INDEX ADR.PHREGDTL_STD_PHDATASRC_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PNSH_MNTBENDTL_FK_I;

CREATE INDEX ADR.PNSH_MNTBENDTL_FK_I ON ADR.PENSION_H
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PNSH_PK;

CREATE UNIQUE INDEX ADR.PNSH_PK ON ADR.PENSION_H
(PENSION_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PNSRSN_PK;

CREATE UNIQUE INDEX ADR.PNSRSN_PK ON ADR.PENSION_REASON
(PENSION_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PNS_MNTBENDTL_FK_I;

CREATE INDEX ADR.PNS_MNTBENDTL_FK_I ON ADR.PENSION
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PNS_PK;

CREATE UNIQUE INDEX ADR.PNS_PK ON ADR.PENSION
(PENSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWH_PK;

CREATE UNIQUE INDEX ADR.POWH_PK ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWH_POWREGID_NU_I;

CREATE INDEX ADR.POWH_POWREGID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWH_PRSNID_NU_I;

CREATE INDEX ADR.POWH_PRSNID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWH_REGTRAIT_NU_I;

CREATE INDEX ADR.POWH_REGTRAIT_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTH_PK;

CREATE UNIQUE INDEX ADR.POWREGDTH_PK ON ADR.POW_REGISTRY_DETAIL_H
(POW_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTH_POWREGID_NU_I;

CREATE INDEX ADR.POWREGDTH_POWREGID_NU_I ON ADR.POW_REGISTRY_DETAIL_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_PK;

CREATE UNIQUE INDEX ADR.POWREGDTL_PK ON ADR.POW_REGISTRY_DETAIL
(POW_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_POWCSLTLOC_FK_I;

CREATE INDEX ADR.POWREGDTL_POWCSLTLOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(STD_POWCASUALTYLOCATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_POW_FK_I;

CREATE INDEX ADR.POWREGDTL_POW_FK_I ON ADR.POW_REGISTRY_DETAIL
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_STD_POWDATASRC_FK_I;

CREATE INDEX ADR.POWREGDTL_STD_POWDATASRC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_STD_POWDOC_FK_I;

CREATE INDEX ADR.POWREGDTL_STD_POWDOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POWREGDTL_STD_POWPRD_FK_I;

CREATE INDEX ADR.POWREGDTL_STD_POWPRD_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_CONFINE_LOCN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POW_LGCYICN_NU_I;

CREATE INDEX ADR.POW_LGCYICN_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY
(LEGACY_ICN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POW_PK;

CREATE UNIQUE INDEX ADR.POW_PK ON ADR.PRISONER_OF_WAR_REGISTRY
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POW_PRSN_FK_I;

CREATE INDEX ADR.POW_PRSN_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POW_REGTRAIT_FK_I;

CREATE INDEX ADR.POW_REGTRAIT_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.POW_STDYESNO_FK_I;

CREATE INDEX ADR.POW_STDYESNO_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(POW_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PPA_STDINS_FK_I;

CREATE INDEX ADR.PPA_STDINS_FK_I ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PREFRRREDFAC_PER_ID_NU_I;

CREATE INDEX ADR.PREFRRREDFAC_PER_ID_NU_I ON ADR.PREFERRED_FACILITY_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.PREFRRRED_FAC_ID_NU_I;

CREATE INDEX ADR.PREFRRRED_FAC_ID_NU_I ON ADR.PREFERRED_FACILITY_H
(PREFERRED_FACILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.PRFFCLH_PK;

CREATE UNIQUE INDEX ADR.PRFFCLH_PK ON ADR.PREFERRED_FACILITY_H
(PREFERRED_FACILITY_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRFFCL_PK;

CREATE UNIQUE INDEX ADR.PRFFCL_PK ON ADR.PREFERRED_FACILITY
(PREFERRED_FACILITY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRFFCL_STDINS_NU_I;

CREATE INDEX ADR.PRFFCL_STDINS_NU_I ON ADR.PREFERRED_FACILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRMSTPRMH_PK;

CREATE UNIQUE INDEX ADR.PRMSTPRMH_PK ON ADR.PERMISSION_SET_PERMISSIONS_H
(PERM_SET_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRMSTPRM_PK;

CREATE UNIQUE INDEX ADR.PRMSTPRM_PK ON ADR.PERMISSION_SET_PERMISSIONS
(PERM_SET_PERMISSIONS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_PK;

CREATE UNIQUE INDEX ADR.PRPLHRTREG_PK ON ADR.PURPLE_HEART_REGISTRY
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_PRSN_FK_I;

CREATE INDEX ADR.PRPLHRTREG_PRSN_FK_I ON ADR.PURPLE_HEART_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_REGTRAIT_FK_I;

CREATE INDEX ADR.PRPLHRTREG_REGTRAIT_FK_I ON ADR.PURPLE_HEART_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_STDINST_FK_I;

CREATE INDEX ADR.PRPLHRTREG_STDINST_FK_I ON ADR.PURPLE_HEART_REGISTRY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_STDREJRMRK_FK_I;

CREATE INDEX ADR.PRPLHRTREG_STDREJRMRK_FK_I ON ADR.PURPLE_HEART_REGISTRY
(STD_REJECTEDREMARKS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREG_STD_DCRNSTAT_FK_I;

CREATE INDEX ADR.PRPLHRTREG_STD_DCRNSTAT_FK_I ON ADR.PURPLE_HEART_REGISTRY
(PH_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREH_PK;

CREATE UNIQUE INDEX ADR.PRPLHRTREH_PK ON ADR.PURPLE_HEART_REGISTRY_H
(PURPLE_HEART_REGISTRY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREH_PRPLHRTRE_NU_I;

CREATE INDEX ADR.PRPLHRTREH_PRPLHRTRE_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREH_PRSNID_NU_I;

CREATE INDEX ADR.PRPLHRTREH_PRSNID_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRPLHRTREH_REGTRAIT_NU_I;

CREATE INDEX ADR.PRPLHRTREH_REGTRAIT_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCHGLOG_DESC_DT_NU_I;

CREATE INDEX ADR.PRSNCHGLOG_DESC_DT_NU_I ON ADR.PERSON_CHANGE_LOG
(SUBMITTER_DESCRIPTION, SUBMITTED_DATE, INCOME_YEAR, PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCHGLOG_PK;

CREATE UNIQUE INDEX ADR.PRSNCHGLOG_PK ON ADR.PERSON_CHANGE_LOG
(PERSON_CHANGE_LOG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCHGLOG_PRSN_FK_I;

CREATE INDEX ADR.PRSNCHGLOG_PRSN_FK_I ON ADR.PERSON_CHANGE_LOG
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTACH_PK;

CREATE UNIQUE INDEX ADR.PRSNCTACH_PK ON ADR.PERSON_CONTACT_H
(PERSON_CONTACT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTACH_PRSNID_NU_I;

CREATE INDEX ADR.PRSNCTACH_PRSNID_NU_I ON ADR.PERSON_CONTACT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTAC_PK;

CREATE UNIQUE INDEX ADR.PRSNCTAC_PK ON ADR.PERSON_CONTACT
(PERSON_CONTACT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTAC_PRSN_FK_I;

CREATE INDEX ADR.PRSNCTAC_PRSN_FK_I ON ADR.PERSON_CONTACT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTAC_STDINST2_FK_I;

CREATE INDEX ADR.PRSNCTAC_STDINST2_FK_I ON ADR.PERSON_CONTACT
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNCTAC_STD_PRNSCTAC_FK_I;

CREATE INDEX ADR.PRSNCTAC_STD_PRNSCTAC_FK_I ON ADR.PERSON_CONTACT
(PERSON_CONTACT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTH_PK;

CREATE UNIQUE INDEX ADR.PRSNETNCTH_PK ON ADR.PERSON_ETHNICITY_H
(PERSON_ETHNICITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTH_PRSNID_NU_I;

CREATE INDEX ADR.PRSNETNCTH_PRSNID_NU_I ON ADR.PERSON_ETHNICITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTY_PK;

CREATE UNIQUE INDEX ADR.PRSNETNCTY_PK ON ADR.PERSON_ETHNICITY
(PERSON_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTY_PRSN_FK_I;

CREATE INDEX ADR.PRSNETNCTY_PRSN_FK_I ON ADR.PERSON_ETHNICITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTY_STDETH_FK_I;

CREATE INDEX ADR.PRSNETNCTY_STDETH_FK_I ON ADR.PERSON_ETHNICITY
(STD_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTY_STDINST2_FK_I;

CREATE INDEX ADR.PRSNETNCTY_STDINST2_FK_I ON ADR.PERSON_ETHNICITY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNETNCTY_STD_CLLNMTHD_FK_I;

CREATE INDEX ADR.PRSNETNCTY_STD_CLLNMTHD_FK_I ON ADR.PERSON_ETHNICITY
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNH_PK;

CREATE UNIQUE INDEX ADR.PRSNH_PK ON ADR.PERSON_H
(PERSON_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNH_PRSNID_NU_I;

CREATE INDEX ADR.PRSNH_PRSNID_NU_I ON ADR.PERSON_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNMRG_DEPRECPRSNID_NU_I;

CREATE INDEX ADR.PRSNMRG_DEPRECPRSNID_NU_I ON ADR.PERSON_MERGE
(DEPRECATED_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNMRG_PK;

CREATE UNIQUE INDEX ADR.PRSNMRG_PK ON ADR.PERSON_MERGE
(PERSON_MERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNMRG_PRIMRYPRSNID_NU_I;

CREATE INDEX ADR.PRSNMRG_PRIMRYPRSNID_NU_I ON ADR.PERSON_MERGE
(PRIMARY_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNPRFLNG_PRSN_ID_UI;

CREATE UNIQUE INDEX ADR.PRSNPRFLNG_PRSN_ID_UI ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACEH_PK;

CREATE UNIQUE INDEX ADR.PRSNRACEH_PK ON ADR.PERSON_RACE_H
(PERSON_RACE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACEH_PRSNID_NU_I;

CREATE INDEX ADR.PRSNRACEH_PRSNID_NU_I ON ADR.PERSON_RACE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACE_PK;

CREATE UNIQUE INDEX ADR.PRSNRACE_PK ON ADR.PERSON_RACE
(PERSON_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACE_PRSN_FK_I;

CREATE INDEX ADR.PRSNRACE_PRSN_FK_I ON ADR.PERSON_RACE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACE_STDINST2_FK_I;

CREATE INDEX ADR.PRSNRACE_STDINST2_FK_I ON ADR.PERSON_RACE
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACE_STDRACE_FK_I;

CREATE INDEX ADR.PRSNRACE_STDRACE_FK_I ON ADR.PERSON_RACE
(STD_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRACE_STD_CLLNMTHD_FK_I;

CREATE INDEX ADR.PRSNRACE_STD_CLLNMTHD_FK_I ON ADR.PERSON_RACE
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELH_PK;

CREATE UNIQUE INDEX ADR.PRSNRELH_PK ON ADR.PERSON_RELATION_H
(PERSON_RELATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELH_PRSNID_NU_I;

CREATE INDEX ADR.PRSNRELH_PRSNID_NU_I ON ADR.PERSON_RELATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELH_PRSNRELID_NU_I;

CREATE INDEX ADR.PRSNRELH_PRSNRELID_NU_I ON ADR.PERSON_RELATION_H
(PERSON_RELATION_ID, PRSN_RELATION_MAPPING_TYPE_CD)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELMRG_PK;

CREATE UNIQUE INDEX ADR.PRSNRELMRG_PK ON ADR.PERSON_RELATION_MERGE
(PERSON_RELATION_MERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELMRG_PRSN_FK_I;

CREATE INDEX ADR.PRSNRELMRG_PRSN_FK_I ON ADR.PERSON_RELATION_MERGE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNRELUNM_PK;

CREATE UNIQUE INDEX ADR.PRSNRELUNM_PK ON ADR.PERSON_RELATION_UNMERGE
(PERSON_RELATION_UNMERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNREL_PK;

CREATE UNIQUE INDEX ADR.PRSNREL_PK ON ADR.PERSON_RELATION
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNREL_PRSN_FK_I;

CREATE INDEX ADR.PRSNREL_PRSN_FK_I ON ADR.PERSON_RELATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNREL_SG_FK_I;

CREATE INDEX ADR.PRSNREL_SG_FK_I ON ADR.PERSON_RELATION
(STD_GENDER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNREL_STD_PRSNREL_FK_I;

CREATE INDEX ADR.PRSNREL_STD_PRSNREL_FK_I ON ADR.PERSON_RELATION
(PRSN_RELATION_MAPPING_TYPE_CD)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNREL_STD_RELTYP_FK_I;

CREATE INDEX ADR.PRSNREL_STD_RELTYP_FK_I ON ADR.PERSON_RELATION
(PERSON_RELATION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSNUNMRG_PK;

CREATE UNIQUE INDEX ADR.PRSNUNMRG_PK ON ADR.PERSON_UNMERGE
(PERSON_UNMERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_CLMFLDRNO_NU_I;

CREATE INDEX ADR.PRSN_CLMFLDRNO_NU_I ON ADR.PERSON
(CLAIM_FOLDER_NUMBER)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_ENRLEESITE_FK_I;

CREATE INDEX ADR.PRSN_ENRLEESITE_FK_I ON ADR.PERSON
(USER_ENROLEE_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_PK;

CREATE UNIQUE INDEX ADR.PRSN_PK ON ADR.PERSON
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_PSPRSNVPID_FK_I;

CREATE INDEX ADR.PRSN_PSPRSNVPID_FK_I ON ADR.PERSON
(VPID_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_SNSTCHGTYP_FK_I;

CREATE INDEX ADR.PRSN_SNSTCHGTYP_FK_I ON ADR.PERSON
(SENSITIVITY_FLAG_SET_SRC_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDINST2_FK_I;

CREATE INDEX ADR.PRSN_STDINST2_FK_I ON ADR.PERSON
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDINST_FK_I;

CREATE INDEX ADR.PRSN_STDINST_FK_I ON ADR.PERSON
(DEATH_REPORTING_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDINST_H_FK_2_I;

CREATE INDEX ADR.PRSN_STDINST_H_FK_2_I ON ADR.PERSON
(SENSITIVITY_FLAG_SET_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDINST_H_FK_I;

CREATE INDEX ADR.PRSN_STDINST_H_FK_I ON ADR.PERSON
(CLAIM_FOLDER_LOCATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDINST_PREF_FAC_FK_I;

CREATE INDEX ADR.PRSN_STDINST_PREF_FAC_FK_I ON ADR.PERSON
(PREFERRED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDMAR_FK_I;

CREATE INDEX ADR.PRSN_STDMAR_FK_I ON ADR.PERSON
(STD_MARITALSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDMSQS_FK_I;

CREATE INDEX ADR.PRSN_STDMSQS_FK_I ON ADR.PERSON
(STD_MILITARYSVCQRYSTAT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDPGMSTDY_FK_I;

CREATE INDEX ADR.PRSN_STDPGMSTDY_FK_I ON ADR.PERSON
(STD_PROGRAMOFSTUDY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STDREL_FK_I;

CREATE INDEX ADR.PRSN_STDREL_FK_I ON ADR.PERSON
(STD_RELIGION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_STD_DEATHNOTIFY_FK_I;

CREATE INDEX ADR.PRSN_STD_DEATHNOTIFY_FK_I ON ADR.PERSON
(DEATH_NOTIFICATION_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PRSN_VPIDVALUE_NU_I;

CREATE INDEX ADR.PRSN_VPIDVALUE_NU_I ON ADR.PERSON
(VPID_VALUE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PSETPRM_PERMSET_FK_I;

CREATE INDEX ADR.PSETPRM_PERMSET_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PSETPRM_STD_PERM_FK_I;

CREATE INDEX ADR.PSETPRM_STD_PERM_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.PURPOSE_OF_USE_TYPE_PK;

CREATE UNIQUE INDEX ADR.PURPOSE_OF_USE_TYPE_PK ON ADR.PURPOSE_OF_USE_TYPE
(PURPOSE_OF_USE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_BLOBTRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_BLOBTRGGR_PK ON ADR.QRTZ_BLOB_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_CLNDR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_CLNDR_PK ON ADR.QRTZ_CALENDARS
(CALENDAR_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_CRNTRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_CRNTRGGR_PK ON ADR.QRTZ_CRON_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_FRDTRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_FRDTRGGR_PK ON ADR.QRTZ_FIRED_TRIGGERS
(ENTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_JBDTL_PK;

CREATE UNIQUE INDEX ADR.QRTZ_JBDTL_PK ON ADR.QRTZ_JOB_DETAILS
(JOB_NAME, JOB_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_JBLSTNR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_JBLSTNR_PK ON ADR.QRTZ_JOB_LISTENERS
(JOB_NAME, JOB_GROUP, JOB_LISTENER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_LOCKS_PK;

CREATE UNIQUE INDEX ADR.QRTZ_LOCKS_PK ON ADR.QRTZ_LOCKS
(LOCK_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_PUSDTRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_PUSDTRGGR_PK ON ADR.QRTZ_PAUSED_TRIGGER_GRPS
(TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_SCHDST_PK;

CREATE UNIQUE INDEX ADR.QRTZ_SCHDST_PK ON ADR.QRTZ_SCHEDULER_STATE
(INSTANCE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_SMPTRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_SMPTRGGR_PK ON ADR.QRTZ_SIMPLE_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_TRGGRLSTNR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_TRGGRLSTNR_PK ON ADR.QRTZ_TRIGGER_LISTENERS
(TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.QRTZ_TRGGR_PK;

CREATE UNIQUE INDEX ADR.QRTZ_TRGGR_PK ON ADR.QRTZ_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDET_PK;

CREATE UNIQUE INDEX ADR.RATEDISDET_PK ON ADR.RATED_DISABILITY_DETAIL
(RATED_DISABILITY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDET_STDDSBLCND_FK_I;

CREATE INDEX ADR.RATEDISDET_STDDSBLCND_FK_I ON ADR.RATED_DISABILITY_DETAIL
(STD_DISABILITYCONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDET_SVCCON_FK_I;

CREATE INDEX ADR.RATEDISDET_SVCCON_FK_I ON ADR.RATED_DISABILITY_DETAIL
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDET_XTRMTY_FK_I;

CREATE INDEX ADR.RATEDISDET_XTRMTY_FK_I ON ADR.RATED_DISABILITY_DETAIL
(DIAGNOSTIC_EXTREMITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDTH_PK;

CREATE UNIQUE INDEX ADR.RATEDISDTH_PK ON ADR.RATED_DISABILITY_DETAIL_H
(RATED_DISABILITY_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RATEDISDTH_SVCCON_NU_I;

CREATE INDEX ADR.RATEDISDTH_SVCCON_NU_I ON ADR.RATED_DISABILITY_DETAIL_H
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RCVDSRVLOG_SRVLOGID_FK_I;

CREATE INDEX ADR.RCVDSRVLOG_SRVLOGID_FK_I ON ADR.CCN_RECEIVED_SERVICE_LOG
(CCN_SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGSTAT_STD_REGTYPE_FK_I;

CREATE INDEX ADR.REGSTAT_STD_REGTYPE_FK_I ON ADR.REGISTRY_LOAD_STATISTICS
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAIDTH_PK;

CREATE UNIQUE INDEX ADR.REGTRAIDTH_PK ON ADR.REGISTRY_TRAIT_DETAIL_H
(REGISTRY_TRAIT_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITDTH_REGTRAIT_NU_I;

CREATE INDEX ADR.REGTRAITDTH_REGTRAIT_NU_I ON ADR.REGISTRY_TRAIT_DETAIL_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITDTL_MILSVCNBR_FB_I;

CREATE INDEX ADR.REGTRAITDTL_MILSVCNBR_FB_I ON ADR.REGISTRY_TRAIT_DETAIL
(UPPER("MILITARY_SERVICE_NUMBER"))
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITDT_PK;

CREATE UNIQUE INDEX ADR.REGTRAITDT_PK ON ADR.REGISTRY_TRAIT_DETAIL
(REGISTRY_TRAIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITDT_REGTRAIT_FK_I;

CREATE INDEX ADR.REGTRAITDT_REGTRAIT_FK_I ON ADR.REGISTRY_TRAIT_DETAIL
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITH_PK;

CREATE UNIQUE INDEX ADR.REGTRAITH_PK ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAITH_REGTRAIT_NU_I;

CREATE INDEX ADR.REGTRAITH_REGTRAIT_NU_I ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAIT_FNAME_FB_I;

CREATE INDEX ADR.REGTRAIT_FNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("FIRST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.REGTRAIT_LNAME_FB_I;

CREATE INDEX ADR.REGTRAIT_LNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("LAST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE 4 INSTANCES 1 );
DROP INDEX ADR.REGTRAIT_PK;

CREATE UNIQUE INDEX ADR.REGTRAIT_PK ON ADR.REGISTRY_TRAIT
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAIT_SSN_NU_I;

CREATE INDEX ADR.REGTRAIT_SSN_NU_I ON ADR.REGISTRY_TRAIT
(SSN)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.REGTRAIT_STD_REGTYPE_FK_I;

CREATE INDEX ADR.REGTRAIT_STD_REGTYPE_FK_I ON ADR.REGISTRY_TRAIT
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RGSTRLODX_PK;

CREATE UNIQUE INDEX ADR.RGSTRLODX_PK ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_EXCEPTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RGSTRLODX_RGSTRYSTAT_FK_I;

CREATE INDEX ADR.RGSTRLODX_RGSTRYSTAT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RGSTRLODX_STD_RPTEXCPT_FK_I;

CREATE INDEX ADR.RGSTRLODX_STD_RPTEXCPT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RGSTRYSTAT_PK;

CREATE UNIQUE INDEX ADR.RGSTRYSTAT_PK ON ADR.REGISTRY_LOAD_STATISTICS
(REGISTRY_LOAD_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RLXHINCYR_I;

CREATE INDEX ADR.RLXHINCYR_I ON ADR.RELAXATION_PERCENTAGE_H
(INCOME_YEAR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RLXINCYR_I;

CREATE INDEX ADR.RLXINCYR_I ON ADR.RELAXATION_PERCENTAGE
(INCOME_YEAR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RLXPCTH_PK;

CREATE UNIQUE INDEX ADR.RLXPCTH_PK ON ADR.RELAXATION_PERCENTAGE_H
(RELAXATION_PERCENTAGE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RLXPCT_PK;

CREATE UNIQUE INDEX ADR.RLXPCT_PK ON ADR.RELAXATION_PERCENTAGE
(RELAXATION_PERCENTAGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMST_PERMSET_FK_I;

CREATE INDEX ADR.ROLEPERMST_PERMSET_FK_I ON ADR.ROLE_PERMISSION_SETS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMST_PK;

CREATE UNIQUE INDEX ADR.ROLEPERMST_PK ON ADR.ROLE_PERMISSION_SETS
(ROLE_PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMST_ROLE_FK_I;

CREATE INDEX ADR.ROLEPERMST_ROLE_FK_I ON ADR.ROLE_PERMISSION_SETS
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMS_PK;

CREATE UNIQUE INDEX ADR.ROLEPERMS_PK ON ADR.ROLE_PERMISSIONS
(ROLE_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMS_ROLE_FK_I;

CREATE INDEX ADR.ROLEPERMS_ROLE_FK_I ON ADR.ROLE_PERMISSIONS
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPERMS_STD_PERM_FK_I;

CREATE INDEX ADR.ROLEPERMS_STD_PERM_FK_I ON ADR.ROLE_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPRMSH_PK;

CREATE UNIQUE INDEX ADR.ROLEPRMSH_PK ON ADR.ROLE_PERMISSIONS_H
(ROLE_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLEPRMSTH_PK;

CREATE UNIQUE INDEX ADR.ROLEPRMSTH_PK ON ADR.ROLE_PERMISSION_SETS_H
(ROLE_PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLESH_PK;

CREATE UNIQUE INDEX ADR.ROLESH_PK ON ADR.ROLES_H
(ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLE_PK;

CREATE UNIQUE INDEX ADR.ROLE_PK ON ADR.ROLES
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.ROLE_U_CODE_UK;

CREATE UNIQUE INDEX ADR.ROLE_U_CODE_UK ON ADR.ROLES
(ROLE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCANDECL_CANDCLNRSN_FK_I;

CREATE INDEX ADR.RPTCANDECL_CANDCLNRSN_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(CANCEL_DECLINE_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCANDECL_PK;

CREATE UNIQUE INDEX ADR.RPTCANDECL_PK ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_CANCEL_DECLINE_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCANDECL_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTCANDECL_SCHEDRPT_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMERR_COMERRTYP_FK_I;

CREATE INDEX ADR.RPTCOMERR_COMERRTYP_FK_I ON ADR.RPT_COM_ERROR
(COM_AAC_ERROR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMERR_PK;

CREATE UNIQUE INDEX ADR.RPTCOMERR_PK ON ADR.RPT_COM_ERROR
(RPT_COM_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMERR_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTCOMERR_SCHEDRPT_FK_I ON ADR.RPT_COM_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMRJCT_COMAACRJCT_FK_I;

CREATE INDEX ADR.RPTCOMRJCT_COMAACRJCT_FK_I ON ADR.RPT_COM_REJECT_REASON
(COM_AAC_REJECT_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMRJCT_PK;

CREATE UNIQUE INDEX ADR.RPTCOMRJCT_PK ON ADR.RPT_COM_REJECT_REASON
(RPT_COM_REJECT_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTCOMRJCT_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTCOMRJCT_SCHEDRPT_FK_I ON ADR.RPT_COM_REJECT_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTDAYOFWK_PK;

CREATE UNIQUE INDEX ADR.RPTDAYOFWK_PK ON ADR.RPT_DAY_OF_WEEK
(RPT_DAY_OF_WEEK_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTDAYOFWK_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTDAYOFWK_SCHEDRPT_FK_I ON ADR.RPT_DAY_OF_WEEK
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTDOWK_STD_RPTDYWKTYP_FK_I;

CREATE INDEX ADR.RPTDOWK_STD_RPTDYWKTYP_FK_I ON ADR.RPT_DAY_OF_WEEK
(RPT_DAY_OF_WEEK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTEEDWKLY_PK;

CREATE UNIQUE INDEX ADR.RPTEEDWKLY_PK ON ADR.RPT_EED_WEEKLY
(RPT_EED_WEEKLY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTELGFCTR_PK;

CREATE UNIQUE INDEX ADR.RPTELGFCTR_PK ON ADR.RPT_ELIGIBILITY_FACTOR
(RPT_ELIGIBILITY_FACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTELGFCTR_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTELGFCTR_SCHEDRPT_FK_I ON ADR.RPT_ELIGIBILITY_FACTOR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTELGFCTR_STDRPTELGF_FK_I;

CREATE INDEX ADR.RPTELGFCTR_STDRPTELGF_FK_I ON ADR.RPT_ELIGIBILITY_FACTOR
(STD_REPORTELIGFACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRLCAT_PK;

CREATE UNIQUE INDEX ADR.RPTENRLCAT_PK ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_ENROLLMENT_CATEGORY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRLCAT_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTENRLCAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRLCAT_STD_ENRLMNTCAT_FK_I;

CREATE INDEX ADR.RPTENRLCAT_STD_ENRLMNTCAT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(STD_ENROLLMENTCATTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENROVER_PK;

CREATE UNIQUE INDEX ADR.RPTENROVER_PK ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_ENROLLMENT_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENROVER_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTENROVER_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENROVER_STDENROVRD_FK_I;

CREATE INDEX ADR.RPTENROVER_STDENROVRD_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(STD_ENRLOVERRIDEREASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRSTAT_ENRLMTSTAT_FK_I;

CREATE INDEX ADR.RPTENRSTAT_ENRLMTSTAT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRSTAT_PK;

CREATE UNIQUE INDEX ADR.RPTENRSTAT_PK ON ADR.RPT_ENROLLMENT_STATUS
(RPT_ENROLLMENT_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTENRSTAT_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTENRSTAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTEWK_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTEWK_SCHEDRPT_FK_I ON ADR.RPT_EED_WEEKLY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTEWK_STD_EEDWKLYTYP_FK_I;

CREATE INDEX ADR.RPTEWK_STD_EEDWKLYTYP_FK_I ON ADR.RPT_EED_WEEKLY
(RPT_EED_WEEKLY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTINVADDR_ADDRINVTYP_FK_I;

CREATE INDEX ADR.RPTINVADDR_ADDRINVTYP_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTINVADDR_PK;

CREATE UNIQUE INDEX ADR.RPTINVADDR_PK ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_INVALID_ADDRESS_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTINVADDR_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTINVADDR_SCHEDRPT_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTLTRFLTP_PK;

CREATE UNIQUE INDEX ADR.RPTLTRFLTP_PK ON ADR.RPT_LETTER_FILE
(RPT_LETTER_FILE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTLTRFLTP_RPTLTRFILE_FK_I;

CREATE INDEX ADR.RPTLTRFLTP_RPTLTRFILE_FK_I ON ADR.RPT_LETTER_FILE
(RPT_LETTER_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTLTRFLTP_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTLTRFLTP_SCHEDRPT_FK_I ON ADR.RPT_LETTER_FILE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSGERR_PK;

CREATE UNIQUE INDEX ADR.RPTMSGERR_PK ON ADR.RPT_MESSAGE_ERROR
(RPT_MESSAGE_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSGERR_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTMSGERR_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSGERR_STD_MSGTYP_FK_I;

CREATE INDEX ADR.RPTMSGERR_STD_MSGTYP_FK_I ON ADR.RPT_MESSAGE_ERROR
(ACK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSG_HL7TRANTYP_FK_I;

CREATE INDEX ADR.RPTMSG_HL7TRANTYP_FK_I ON ADR.RPT_MESSAGE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSG_PK;

CREATE UNIQUE INDEX ADR.RPTMSG_PK ON ADR.RPT_MESSAGE
(RPT_MESSAGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTMSG_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTMSG_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPERM_PK;

CREATE UNIQUE INDEX ADR.RPTPERM_PK ON ADR.RPT_PERMISSIONS
(RPT_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPERM_STD_PERM_FK_I;

CREATE INDEX ADR.RPTPERM_STD_PERM_FK_I ON ADR.RPT_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPERM_STD_RPTTYPE_FK_I;

CREATE INDEX ADR.RPTPERM_STD_RPTTYPE_FK_I ON ADR.RPT_PERMISSIONS
(RPT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPGRP_STD_ENRLMNTPSGRP_FK_I;

CREATE INDEX ADR.RPTPGRP_STD_ENRLMNTPSGRP_FK_I ON ADR.RPT_PRIORITY_GROUP
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPHRJCT_PK;

CREATE UNIQUE INDEX ADR.RPTPHRJCT_PK ON ADR.RPT_PH_REJECT_REASON
(RPT_PH_REJECT_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPHRJCT_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTPHRJCT_SCHEDRPT_FK_I ON ADR.RPT_PH_REJECT_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPHRJCT_STDREJRMRK_FK_I;

CREATE INDEX ADR.RPTPHRJCT_STDREJRMRK_FK_I ON ADR.RPT_PH_REJECT_REASON
(STD_REJECTEDREMARKS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRIOGRP_PK;

CREATE UNIQUE INDEX ADR.RPTPRIOGRP_PK ON ADR.RPT_PRIORITY_GROUP
(RPT_PRIORITY_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRIOGRP_PRTYGRP_FK_I;

CREATE INDEX ADR.RPTPRIOGRP_PRTYGRP_FK_I ON ADR.RPT_PRIORITY_GROUP
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRIOGRP_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTPRIOGRP_SCHEDRPT_FK_I ON ADR.RPT_PRIORITY_GROUP
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRSNMRG_PK;

CREATE UNIQUE INDEX ADR.RPTPRSNMRG_PK ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_PERSON_MERGE_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRSNMRG_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTPRSNMRG_SCHEDRPT_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTPRSNMRG_STDPRSNMRG_FK_I;

CREATE INDEX ADR.RPTPRSNMRG_STDPRSNMRG_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(STD_PERSONMERGESTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTQRYSITE_PK;

CREATE UNIQUE INDEX ADR.RPTQRYSITE_PK ON ADR.RPT_QUERY_SITE
(REPORT_QUERY_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTQRYSITE_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTQRYSITE_SCHEDRPT_FK_I ON ADR.RPT_QUERY_SITE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTQRYSITE_STDINST_FK_I;

CREATE INDEX ADR.RPTQRYSITE_STDINST_FK_I ON ADR.RPT_QUERY_SITE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTRGSTRY_PK;

CREATE UNIQUE INDEX ADR.RPTRGSTRY_PK ON ADR.RPT_REGISTRY
(RPT_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTRGSTRY_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTRGSTRY_SCHEDRPT_FK_I ON ADR.RPT_REGISTRY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTRGSTRY_STD_REGTYPE_FK_I;

CREATE INDEX ADR.RPTRGSTRY_STD_REGTYPE_FK_I ON ADR.RPT_REGISTRY
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSITE_PK;

CREATE UNIQUE INDEX ADR.RPTSITE_PK ON ADR.RPT_SITE
(RPT_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSITE_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTSITE_SCHEDRPT_FK_I ON ADR.RPT_SITE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSITE_STDINST_FK_I;

CREATE INDEX ADR.RPTSITE_STDINST_FK_I ON ADR.RPT_SITE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSTATCMP_PK;

CREATE UNIQUE INDEX ADR.RPTSTATCMP_PK ON ADR.RPT_STATUS_COMPONENT
(RPT_STATUS_COMPONENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSTATCMP_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTSTATCMP_SCHEDRPT_FK_I ON ADR.RPT_STATUS_COMPONENT
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTSTATCMP_STDRPTSTCM_FK_I;

CREATE INDEX ADR.RPTSTATCMP_STDRPTSTCM_FK_I ON ADR.RPT_STATUS_COMPONENT
(STD_RPTSTATUSCOMPONENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSERS_PK;

CREATE UNIQUE INDEX ADR.RPTUSERS_PK ON ADR.RPT_USERS
(RPT_USER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSERS_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTUSERS_SCHEDRPT_FK_I ON ADR.RPT_USERS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSERS_USER_1_FK_I;

CREATE INDEX ADR.RPTUSERS_USER_1_FK_I ON ADR.RPT_USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSRGRP_PK;

CREATE UNIQUE INDEX ADR.RPTUSRGRP_PK ON ADR.RPT_USER_GROUP
(RPT_USER_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSRGRP_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTUSRGRP_SCHEDRPT_FK_I ON ADR.RPT_USER_GROUP
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTUSRGRP_USRGRPTYP_FK_I;

CREATE INDEX ADR.RPTUSRGRP_USRGRPTYP_FK_I ON ADR.RPT_USER_GROUP
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTVBAQRY_PK;

CREATE UNIQUE INDEX ADR.RPTVBAQRY_PK ON ADR.RPT_VBA_QUERY_STATUS
(RPT_VBA_QUERY_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTVBAQRY_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTVBAQRY_SCHEDRPT_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTVBAQRY_STD_VBAQURYST_FK_I;

CREATE INDEX ADR.RPTVBAQRY_STD_VBAQURYST_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(VBA_QUERY_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTWKFCASE_PK;

CREATE UNIQUE INDEX ADR.RPTWKFCASE_PK ON ADR.RPT_WKF_CASE
(RPT_WKF_CASE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTWKFCASE_SCHEDRPT_FK_I;

CREATE INDEX ADR.RPTWKFCASE_SCHEDRPT_FK_I ON ADR.RPT_WKF_CASE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPTWKFCASE_WKFCASETYP_FK_I;

CREATE INDEX ADR.RPTWKFCASE_WKFCASETYP_FK_I ON ADR.RPT_WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPT_FORM_TYPE_ID_PK;

CREATE UNIQUE INDEX ADR.RPT_FORM_TYPE_ID_PK ON ADR.RPT_FORM_TYPE
(RPT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPT_SORTBY_TYPE_CD_UK;

CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_CD_UK ON ADR.RPT_SORTBY_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPT_SORTBY_TYPE_DESC_UK;

CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_DESC_UK ON ADR.RPT_SORTBY_TYPE
(DESCRIPTION)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.RPT_SORTBY_TYPE_PK;

CREATE UNIQUE INDEX ADR.RPT_SORTBY_TYPE_PK ON ADR.RPT_SORTBY_TYPE
(RPT_SORTBY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SCHEDRPT_PK;

CREATE UNIQUE INDEX ADR.SCHEDRPT_PK ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SCHEDRPT_RPTDIVTYPE_FK_I;

CREATE INDEX ADR.SCHEDRPT_RPTDIVTYPE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DIVISION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SCHEDRPT_RPTWRKITM_FK_I;

CREATE INDEX ADR.SCHEDRPT_RPTWRKITM_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WORK_ITEM_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SCHEDRPT_USER_1_FK_I;

CREATE INDEX ADR.SCHEDRPT_USER_1_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SEEDING_PK;

CREATE UNIQUE INDEX ADR.SEEDING_PK ON ADR.SEEDING
(SEEDING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SEED_PRSN_FK_I;

CREATE INDEX ADR.SEED_PRSN_FK_I ON ADR.SEEDING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SEED_SEEDSTAT_FK_I;

CREATE INDEX ADR.SEED_SEEDSTAT_FK_I ON ADR.SEEDING
(STD_SEEDSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SEED_STDINST_FK_I;

CREATE INDEX ADR.SEED_STDINST_FK_I ON ADR.SEEDING
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SELF_IDENTIFIED_GENDER_PK;

CREATE UNIQUE INDEX ADR.SELF_IDENTIFIED_GENDER_PK ON ADR.SELF_IDENTIFIED_GENDER
(SELF_IDENTIFIED_GENDER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADREGDH_PK;

CREATE UNIQUE INDEX ADR.SHADREGDH_PK ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADREGDH_SHADRGSTRY_FK_I;

CREATE INDEX ADR.SHADREGDH_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADREGDTL_PK;

CREATE UNIQUE INDEX ADR.SHADREGDTL_PK ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADREGDTL_SHADRGSTRY_FK_I;

CREATE INDEX ADR.SHADREGDTL_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADREGDTL_STD_SHADOCTYP_FK_I;

CREATE INDEX ADR.SHADREGDTL_STD_SHADOCTYP_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRH_PK;

CREATE UNIQUE INDEX ADR.SHADRGSTRH_PK ON ADR.SHAD_REGISTRY_H
(SHAD_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRH_PRSNID_NU_I;

CREATE INDEX ADR.SHADRGSTRH_PRSNID_NU_I ON ADR.SHAD_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRY_PK;

CREATE UNIQUE INDEX ADR.SHADRGSTRY_PK ON ADR.SHAD_REGISTRY
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRY_PRSN_FK_I;

CREATE INDEX ADR.SHADRGSTRY_PRSN_FK_I ON ADR.SHAD_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRY_REGTRAIT_FK_I;

CREATE INDEX ADR.SHADRGSTRY_REGTRAIT_FK_I ON ADR.SHAD_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SHADRGSTRY_STDYESNO_FK_I;

CREATE INDEX ADR.SHADRGSTRY_STDYESNO_FK_I ON ADR.SHAD_REGISTRY
(SHAD_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATUREH_PK;

CREATE UNIQUE INDEX ADR.SIGNATUREH_PK ON ADR.SIGNATURE_IMAGE_H
(SIGNATURE_IMAGE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATUREH_PRSNID_NU_I;

CREATE INDEX ADR.SIGNATUREH_PRSNID_NU_I ON ADR.SIGNATURE_IMAGE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATURE_PK;

CREATE UNIQUE INDEX ADR.SIGNATURE_PK ON ADR.SIGNATURE_IMAGE
(SIGNATURE_IMAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATURE_PRSN_FK_I;

CREATE INDEX ADR.SIGNATURE_PRSN_FK_I ON ADR.SIGNATURE_IMAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATURE_SIGNINDTYP_FK_I;

CREATE INDEX ADR.SIGNATURE_SIGNINDTYP_FK_I ON ADR.SIGNATURE_IMAGE
(SIGNATURE_INDICATOR_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIGNATURE_STDINST_FK_I;

CREATE INDEX ADR.SIGNATURE_STDINST_FK_I ON ADR.SIGNATURE_IMAGE
(SUBMITTING_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIG_CODE_NU_I;

CREATE INDEX ADR.SIG_CODE_NU_I ON ADR.SELF_IDENTIFIED_GENDER
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SIG_NAME_NU_I;

CREATE INDEX ADR.SIG_NAME_NU_I ON ADR.SELF_IDENTIFIED_GENDER
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_PK;

CREATE UNIQUE INDEX ADR.SITERCVELG_PK ON ADR.SITE_RECEIVED_ELIGIBILITY
(SITE_RECEIVED_ELIGIBILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_PRSN_FK_I;

CREATE INDEX ADR.SITERCVELG_PRSN_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_STDINST_FK_I;

CREATE INDEX ADR.SITERCVELG_STDINST_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_STD_ALIEDCTRY_FK_I;

CREATE INDEX ADR.SITERCVELG_STD_ALIEDCTRY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ALLIED_COUNTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_STD_ELGBTYCODE_FK_I;

CREATE INDEX ADR.SITERCVELG_STD_ELGBTYCODE_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELG_STD_OTHRAGNCY_FK_I;

CREATE INDEX ADR.SITERCVELG_STD_OTHRAGNCY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(FEDERAL_AGENCY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELH_PK;

CREATE UNIQUE INDEX ADR.SITERCVELH_PK ON ADR.SITE_RECEIVED_ELIGIBILITY_H
(SITE_RECEIVED_ELIGIBILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERCVELH_PRSNID_NU_I;

CREATE INDEX ADR.SITERCVELH_PRSNID_NU_I ON ADR.SITE_RECEIVED_ELIGIBILITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERECENH_PK;

CREATE UNIQUE INDEX ADR.SITERECENH_PK ON ADR.SITE_RECEIVED_ENROLLMENT_H
(SITE_RECEIVED_ENROLLMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERECENH_PRSNID_NU_I;

CREATE INDEX ADR.SITERECENH_PRSNID_NU_I ON ADR.SITE_RECEIVED_ENROLLMENT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERECENR_PK;

CREATE UNIQUE INDEX ADR.SITERECENR_PK ON ADR.SITE_RECEIVED_ENROLLMENT
(SITE_RECEIVED_ENROLLMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERECENR_PRSN_FK_I;

CREATE INDEX ADR.SITERECENR_PRSN_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SITERECENR_STDINST_FK_I;

CREATE INDEX ADR.SITERECENR_STDINST_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPCLFCTR_STD_AGNTORNG_FK_I;

CREATE INDEX ADR.SPCLFCTR_STD_AGNTORNG_FK_I ON ADR.SPECIAL_FACTOR
(AGENT_ORANGE_LOCATION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPCLFCTR_STD_RADEXPMTHD_FK_I;

CREATE INDEX ADR.SPCLFCTR_STD_RADEXPMTHD_FK_I ON ADR.SPECIAL_FACTOR
(RADIATION_EXP_METHOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPECFACTH_PK;

CREATE UNIQUE INDEX ADR.SPECFACTH_PK ON ADR.SPECIAL_FACTOR_H
(SPECIAL_FACTOR_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPECFACTH_PRSNID_NU_I;

CREATE INDEX ADR.SPECFACTH_PRSNID_NU_I ON ADR.SPECIAL_FACTOR_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPECFACT_PK;

CREATE UNIQUE INDEX ADR.SPECFACT_PK ON ADR.SPECIAL_FACTOR
(SPECIAL_FACTOR_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPECFACT_PRSN_FK_I;

CREATE INDEX ADR.SPECFACT_PRSN_FK_I ON ADR.SPECIAL_FACTOR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SPECFACT_STDYESNO_FK_I;

CREATE INDEX ADR.SPECFACT_STDYESNO_FK_I ON ADR.SPECIAL_FACTOR
(SPECIAL_FACTOR_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SP_FAC_ID_CL_VER_METH_CD_UI;

CREATE UNIQUE INDEX ADR.SP_FAC_ID_CL_VER_METH_CD_UI ON ADR.CL_VERIFICATION_METHOD
(SPECIAL_FACTOR_ID, CL_VERIFICATION_METHOD_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SP_STD_SPECIALFACTORMAP_FK_I;

CREATE INDEX ADR.SP_STD_SPECIALFACTORMAP_FK_I ON ADR.SPECIAL_FACTOR
(SPCL_FACTOR_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTDAYQRTR_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTDAYQRTR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_QUARTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTDTLBY_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTDTLBY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_BY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTDTLFOR_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTDTLFOR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_FOR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTDYWKTYP_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTDYWKTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_WEEK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTENRLPRSTAT_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTENRLPRSTAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_ENROLLPRSTAT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTEXCPT_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTEXCPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTFORMAT_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTFORMAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FORMAT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTFREQTYP_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTFREQTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_RUN_FREQUENCY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTMNTHDAY_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTMNTHDAY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTMTHLST_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTMTHLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_MONTH_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTOUTFILE_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTOUTFILE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTPERIOD_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTPERIOD_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_PERIOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTQRTRLST_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTQRTRLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_QUARTER_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTSCHED_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTSCHED_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTSITEDSP_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTSITEDSP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SITE_DISPLAY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTSTDRPT_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTSTDRPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_STANDARD_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SRPT_STD_RPTWKMNTH_FK_I;

CREATE INDEX ADR.SRPT_STD_RPTWKMNTH_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WEEK_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNH_PK;

CREATE UNIQUE INDEX ADR.SSNH_PK ON ADR.SSN_H
(SSN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNH_PRSNID_NU_I;

CREATE INDEX ADR.SSNH_PRSNID_NU_I ON ADR.SSN_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNH_PRSNRELID_NU_I;

CREATE INDEX ADR.SSNH_PRSNRELID_NU_I ON ADR.SSN_H
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERFYDT_PK;

CREATE UNIQUE INDEX ADR.SSNVERFYDT_PK ON ADR.SSN_VERIFICATION_DETAIL
(SSN_VERIFICATION_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERFYDT_PRSN_FK_I;

CREATE INDEX ADR.SSNVERFYDT_PRSN_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERFYDT_SSNVERIFY_FK_I;

CREATE INDEX ADR.SSNVERFYDT_SSNVERIFY_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(SSN_VERIFICATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERFYDT_SSN_FK_I;

CREATE INDEX ADR.SSNVERFYDT_SSN_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(SSN_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERFYDT_VERFRQNO_NU_I;

CREATE INDEX ADR.SSNVERFYDT_VERFRQNO_NU_I ON ADR.SSN_VERIFICATION_DETAIL
(VERIFICATION_REQUEST_NUMBER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSNVERIFY_PK;

CREATE UNIQUE INDEX ADR.SSNVERIFY_PK ON ADR.SSN_VERIFICATION
(SSN_VERIFICATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_PK;

CREATE UNIQUE INDEX ADR.SSN_PK ON ADR.SSN
(SSN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_PRSNREL_FK_I;

CREATE INDEX ADR.SSN_PRSNREL_FK_I ON ADR.SSN
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_PRSN_FK_I;

CREATE INDEX ADR.SSN_PRSN_FK_I ON ADR.SSN
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_SSNTYPE_FK_I;

CREATE INDEX ADR.SSN_SSNTYPE_FK_I ON ADR.SSN
(STD_SSNTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_STD_PSEUDOSSNRSN_FK_I;

CREATE INDEX ADR.SSN_STD_PSEUDOSSNRSN_FK_I ON ADR.SSN
(PSEUDO_SSN_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_STD_SSAVRFNCD_FK_I;

CREATE INDEX ADR.SSN_STD_SSAVRFNCD_FK_I ON ADR.SSN
(SSA_MESSAGE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_STD_SSNCHGSRC_FK_I;

CREATE INDEX ADR.SSN_STD_SSNCHGSRC_FK_I ON ADR.SSN
(SSN_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SSN_STD_SSNVRFNSTAT_FK_I;

CREATE INDEX ADR.SSN_STD_SSNVRFNSTAT_FK_I ON ADR.SSN
(SSN_VRFN_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STOPCOMRSNTYPE_CD_UK;

CREATE UNIQUE INDEX ADR.STOPCOMRSNTYPE_CD_UK ON ADR.STOP_COM_RSN_TYPE
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STOPCOMRSNTYPE_NM_UK;

CREATE UNIQUE INDEX ADR.STOPCOMRSNTYPE_NM_UK ON ADR.STOP_COM_RSN_TYPE
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STOP_COM_RSN_TYPE_PK;

CREATE UNIQUE INDEX ADR.STOP_COM_RSN_TYPE_PK ON ADR.STOP_COM_RSN_TYPE
(STOP_COM_RSN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STRCVDENR_STD_ENRLPGRP_FK_I;

CREATE INDEX ADR.STRCVDENR_STD_ENRLPGRP_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STRCVDENR_STD_ENRLPSGRP_FK_I;

CREATE INDEX ADR.STRCVDENR_STD_ENRLPSGRP_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STRCVDENR_STD_ENRLSRC_FK_I;

CREATE INDEX ADR.STRCVDENR_STD_ENRLSRC_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(ENROLLMENT_DATA_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.STREVDENR_STD_ENRLST_FK_I;

CREATE INDEX ADR.STREVDENR_STD_ENRLST_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SVCCONH_PK;

CREATE UNIQUE INDEX ADR.SVCCONH_PK ON ADR.SERVICE_CONNECTED_H
(SERVICE_CONNECTED_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SVCCONH_PRSNID_NU_I;

CREATE INDEX ADR.SVCCONH_PRSNID_NU_I ON ADR.SERVICE_CONNECTED_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SVCCON_PK;

CREATE UNIQUE INDEX ADR.SVCCON_PK ON ADR.SERVICE_CONNECTED
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.SVCCON_PRSN_FK_I;

CREATE INDEX ADR.SVCCON_PRSN_FK_I ON ADR.SERVICE_CONNECTED
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.TRANSMISSION_STATUS_ID_PK;

CREATE UNIQUE INDEX ADR.TRANSMISSION_STATUS_ID_PK ON ADR.TRANSMISSION_STATUS
(TRANSMISSION_STATUS_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.TRNS_STAT_CODE_NU_I;

CREATE INDEX ADR.TRNS_STAT_CODE_NU_I ON ADR.TRANSMISSION_STATUS
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.TRNS_STAT_NAME_NU_I;

CREATE INDEX ADR.TRNS_STAT_NAME_NU_I ON ADR.TRANSMISSION_STATUS
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.TRNTYP_PK;

CREATE UNIQUE INDEX ADR.TRNTYP_PK ON ADR.TRANSMISSION_TYPE
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERH_PK;

CREATE UNIQUE INDEX ADR.USERH_PK ON ADR.USERS_H
(USERS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERLOGINH_PK;

CREATE UNIQUE INDEX ADR.USERLOGINH_PK ON ADR.USER_LOGIN_H
(USER_LOGIN_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERLOGIN_PK;

CREATE UNIQUE INDEX ADR.USERLOGIN_PK ON ADR.USER_LOGIN
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERLOGIN_USER_1_FK_I;

CREATE INDEX ADR.USERLOGIN_USER_1_FK_I ON ADR.USER_LOGIN
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERMST_PERMSET_FK_I;

CREATE INDEX ADR.USERPERMST_PERMSET_FK_I ON ADR.USER_PERMISSION_SETS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERMST_PK;

CREATE UNIQUE INDEX ADR.USERPERMST_PK ON ADR.USER_PERMISSION_SETS
(USER_PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERMST_USER_1_FK_I;

CREATE INDEX ADR.USERPERMST_USER_1_FK_I ON ADR.USER_PERMISSION_SETS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERM_PK;

CREATE UNIQUE INDEX ADR.USERPERM_PK ON ADR.USER_PERMISSIONS
(USER_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERM_STD_PERM_FK_I;

CREATE INDEX ADR.USERPERM_STD_PERM_FK_I ON ADR.USER_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERPERM_USER_1_FK_I;

CREATE INDEX ADR.USERPERM_USER_1_FK_I ON ADR.USER_PERMISSIONS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERROLEH_PK;

CREATE UNIQUE INDEX ADR.USERROLEH_PK ON ADR.USER_ROLES_H
(USER_ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERROLE_PK;

CREATE UNIQUE INDEX ADR.USERROLE_PK ON ADR.USER_ROLES
(USER_ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERROLE_ROLE_FK_I;

CREATE INDEX ADR.USERROLE_ROLE_FK_I ON ADR.USER_ROLES
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USERROLE_USER_1_FK_I;

CREATE INDEX ADR.USERROLE_USER_1_FK_I ON ADR.USER_ROLES
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USER_1_STDINST_FK_I;

CREATE INDEX ADR.USER_1_STDINST_FK_I ON ADR.USERS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USER_1_UK2_UK;

CREATE UNIQUE INDEX ADR.USER_1_UK2_UK ON ADR.USERS
(USERNAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USER_1_USRGRPTYP_FK_I;

CREATE INDEX ADR.USER_1_USRGRPTYP_FK_I ON ADR.USERS
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USER_PK;

CREATE UNIQUE INDEX ADR.USER_PK ON ADR.USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USRPERMH_PK;

CREATE UNIQUE INDEX ADR.USRPERMH_PK ON ADR.USER_PERMISSIONS_H
(USER_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.USRPERMSTH_PK;

CREATE UNIQUE INDEX ADR.USRPERMSTH_PK ON ADR.USER_PERMISSION_SETS_H
(USER_PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSNH_PK;

CREATE UNIQUE INDEX ADR.VAPERDVSNH_PK ON ADR.VA_PERSON_DIVISION_DETAIL_H
(VA_PERSON_DIVISION_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSNH_PRSNID_NU_I;

CREATE INDEX ADR.VAPERDVSNH_PRSNID_NU_I ON ADR.VA_PERSON_DIVISION_DETAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSN_PK;

CREATE UNIQUE INDEX ADR.VAPERDVSN_PK ON ADR.VA_PERSON_DIVISION_DETAIL
(VA_PERSON_DIVISION_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSN_PRSN_FK_I;

CREATE INDEX ADR.VAPERDVSN_PRSN_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSN_STDINST2_FK_I;

CREATE INDEX ADR.VAPERDVSN_STDINST2_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPERDVSN_STDINST_FK_I;

CREATE INDEX ADR.VAPERDVSN_STDINST_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAH_PK;

CREATE UNIQUE INDEX ADR.VAPRSNCLAH_PK ON ADR.VA_PERSON_CLASS_DETAIL_H
(VA_PERSON_CLASS_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAH_PRSNID_NU_I;

CREATE INDEX ADR.VAPRSNCLAH_PRSNID_NU_I ON ADR.VA_PERSON_CLASS_DETAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAS_PK;

CREATE UNIQUE INDEX ADR.VAPRSNCLAS_PK ON ADR.VA_PERSON_CLASS_DETAIL
(VA_PERSON_CLASS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAS_PRSN_FK_I;

CREATE INDEX ADR.VAPRSNCLAS_PRSN_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAS_STDINST2_FK_I;

CREATE INDEX ADR.VAPRSNCLAS_STDINST2_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAS_STDINST_FK_I;

CREATE INDEX ADR.VAPRSNCLAS_STDINST_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VAPRSNCLAS_STDPRCLASS_FK_I;

CREATE INDEX ADR.VAPRSNCLAS_STDPRCLASS_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_PERSONCLASS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCADMIN_H_PERSON_ID_NU_I;

CREATE INDEX ADR.VCADMIN_H_PERSON_ID_NU_I ON ADR.VCADMIN_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCADMIN_H_PK;

CREATE UNIQUE INDEX ADR.VCADMIN_H_PK ON ADR.VCADMIN_H
(VCADMIN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCADMIN_PERSON_ID;

CREATE INDEX ADR.VCADMIN_PERSON_ID ON ADR.VCADMIN
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCADMIN_PK;

CREATE UNIQUE INDEX ADR.VCADMIN_PK ON ADR.VCADMIN
(VCADMIN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCADMISTATUS_TYPE_PK;

CREATE UNIQUE INDEX ADR.VCADMISTATUS_TYPE_PK ON ADR.VCADMISTATUS_TYPE
(VCADMISTATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCELIGIBILITY_H_PK;

CREATE UNIQUE INDEX ADR.VCELIGIBILITY_H_PK ON ADR.VCELIGIBILITY_H
(VCELIGIBILITY_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCELIGIBILITY_ID_NU_I;

CREATE INDEX ADR.VCELIGIBILITY_ID_NU_I ON ADR.VCELIGIBILITY_H
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );
DROP INDEX ADR.VCELIGIBILITY_PK;

CREATE UNIQUE INDEX ADR.VCELIGIBILITY_PK ON ADR.VCELIGIBILITY
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCELIGIBIL_PERSON_ID;

CREATE INDEX ADR.VCELIGIBIL_PERSON_ID ON ADR.VCELIGIBILITY
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCELI_H_PERSON_ID_NU_I;

CREATE INDEX ADR.VCELI_H_PERSON_ID_NU_I ON ADR.VCELIGIBILITY_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VCESTATUSTYPE_PK;

CREATE UNIQUE INDEX ADR.VCESTATUSTYPE_PK ON ADR.VCESTATUSTYPE
(VCESTATUSTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.VERIFYSUM_PK;

CREATE UNIQUE INDEX ADR.VERIFYSUM_PK ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY
(NCOA_ADDRESS_VERIFY_SUMMARY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WAITTIME_ARCHIVE_PK;

CREATE UNIQUE INDEX ADR.WAITTIME_ARCHIVE_PK ON ADR.WAITTIME_ARCHIVE
(RECORD_CREATED_DATE, WAITTIME_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_ARCHIVE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.WAITTIME_H_PERSONID_NU_I;

CREATE INDEX ADR.WAITTIME_H_PERSONID_NU_I ON ADR.WAITTIME_H
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WAITTIME_H_PERSONID_IDX_P1
    TABLESPACE L_INDEX_01,  
  PARTITION WAITTIME_H_PERSONID_IDX_P2
    TABLESPACE L_INDEX_01,  
  PARTITION WAITTIME_H_PERSONID_IDX_P3
    TABLESPACE L_INDEX_01,  
  PARTITION WAITTIME_H_PERSONID_IDX_P4
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.WAITTIME_H_PK_I;

CREATE UNIQUE INDEX ADR.WAITTIME_H_PK_I ON ADR.WAITTIME_H
(WAITTIME_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WAITTIME_H_RECDTWTTIME_NU_I;

CREATE INDEX ADR.WAITTIME_H_RECDTWTTIME_NU_I ON ADR.WAITTIME_H
(RECORD_CREATED_DATE, WAITTIME_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOCAL (  
  PARTITION WT_RECREATDT_P1
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.WAITTIME_H_VCELIGID_NU_I;

CREATE INDEX ADR.WAITTIME_H_VCELIGID_NU_I ON ADR.WAITTIME_H
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WAITTIME_PK;

CREATE UNIQUE INDEX ADR.WAITTIME_PK ON ADR.WAITTIME
(RECORD_CREATED_DATE, WAITTIME_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.WAITTIME_STAGE_PK;

CREATE UNIQUE INDEX ADR.WAITTIME_STAGE_PK ON ADR.WAITTIME_STAGE
(RECORD_CREATED_DATE, WAITTIME_STAGE_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_STAGE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;
DROP INDEX ADR.WAITTYPE_PK;

CREATE UNIQUE INDEX ADR.WAITTYPE_PK ON ADR.WAITTYPE
(WAITTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASEH_PK;

CREATE UNIQUE INDEX ADR.WKFCASEH_PK ON ADR.WKF_CASE_H
(WKF_CASE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_PK;

CREATE UNIQUE INDEX ADR.WKFCASE_PK ON ADR.WKF_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_PRSN_FK_I;

CREATE INDEX ADR.WKFCASE_PRSN_FK_I ON ADR.WKF_CASE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_STDINST_FK_I;

CREATE INDEX ADR.WKFCASE_STDINST_FK_I ON ADR.WKF_CASE
(REQUEST_RECEIVED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_STD_USRGRPTYP_FK_I;

CREATE INDEX ADR.WKFCASE_STD_USRGRPTYP_FK_I ON ADR.WKF_CASE
(STD_USERGROUPTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_STD_WKFCSTYPE_FK_I;

CREATE INDEX ADR.WKFCASE_STD_WKFCSTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_STD_WKFRQST_FK_I;

CREATE INDEX ADR.WKFCASE_STD_WKFRQST_FK_I ON ADR.WKF_CASE
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCASE_WKFISUTYPE_FK_I;

CREATE INDEX ADR.WKFCASE_WKFISUTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_ISSUE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCMTSH_PK;

CREATE UNIQUE INDEX ADR.WKFCMTSH_PK ON ADR.WKF_CASE_COMMENTS_H
(WKF_CASE_COMMENT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCMTS_PK;

CREATE UNIQUE INDEX ADR.WKFCMTS_PK ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_COMMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCMTS_WKFCASE_FK_I;

CREATE INDEX ADR.WKFCMTS_WKFCASE_FK_I ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSASGH_PK;

CREATE UNIQUE INDEX ADR.WKFCSASGH_PK ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ASSIGNMENT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSASGMT_PK;

CREATE UNIQUE INDEX ADR.WKFCSASGMT_PK ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ASSIGNMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSASGMT_WKFCASE_FK_I;

CREATE INDEX ADR.WKFCSASGMT_WKFCASE_FK_I ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTAT_PK;

CREATE UNIQUE INDEX ADR.WKFCSESTAT_PK ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTAT_STD_WKFACTVTY_FK_I;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFACTVTY_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ACTIVITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTAT_STD_WKFCSST_FK_I;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFCSST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTAT_STD_WKFRQST_FK_I;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFRQST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTAT_WKFCASE_FK_I;

CREATE INDEX ADR.WKFCSESTAT_WKFCASE_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFCSESTH_PK;

CREATE UNIQUE INDEX ADR.WKFCSESTH_PK ON ADR.WKF_CASE_STATUS_DETAIL_H
(WKF_CASE_STATUS_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCSH_PK;

CREATE UNIQUE INDEX ADR.WKFMSGCSH_PK ON ADR.WKF_MESSAGING_CASE_H
(WKF_MESSAGING_CASE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCS_PK;

CREATE UNIQUE INDEX ADR.WKFMSGCS_PK ON ADR.WKF_MESSAGING_CASE
(WKF_MESSAGING_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCS_STDINST_FK_I;

CREATE INDEX ADR.WKFMSGCS_STDINST_FK_I ON ADR.WKF_MESSAGING_CASE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_2_I;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_2_I ON ADR.WKF_MESSAGING_CASE
(ACK_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_I;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_I ON ADR.WKF_MESSAGING_CASE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKFMSGCS_WKFCASE_FK_I;

CREATE INDEX ADR.WKFMSGCS_WKFCASE_FK_I ON ADR.WKF_MESSAGING_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKF_CASE_ASSIGNMENT_H_FK_I;

CREATE INDEX ADR.WKF_CASE_ASSIGNMENT_H_FK_I ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKF_CASE_COMMENTS_H_FK_I;

CREATE INDEX ADR.WKF_CASE_COMMENTS_H_FK_I ON ADR.WKF_CASE_COMMENTS_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKF_CASE_STATUS_DETAIL_H_FK_I;

CREATE INDEX ADR.WKF_CASE_STATUS_DETAIL_H_FK_I ON ADR.WKF_CASE_STATUS_DETAIL_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WKF_MESSAGING_CASE_H_FK_I;

CREATE INDEX ADR.WKF_MESSAGING_CASE_H_FK_I ON ADR.WKF_MESSAGING_CASE_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WTARCH_VCELIG_FK;

CREATE INDEX ADR.WTARCH_VCELIG_FK ON ADR.WAITTIME_ARCHIVE
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WTA_PERSONID_IDX;

CREATE INDEX ADR.WTA_PERSONID_IDX ON ADR.WAITTIME_ARCHIVE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WTA_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.WTSTG_VCELIG_FK;

CREATE INDEX ADR.WTSTG_VCELIG_FK ON ADR.WAITTIME_STAGE
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADR.WTS_PERSONID_IDX;

CREATE INDEX ADR.WTS_PERSONID_IDX ON ADR.WAITTIME_STAGE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WTS_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.WT_PERSONID_IDX;

CREATE INDEX ADR.WT_PERSONID_IDX ON ADR.WAITTIME
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WT_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;
DROP INDEX ADR.WT_VCELIGID_FK;

CREATE INDEX ADR.WT_VCELIGID_FK ON ADR.WAITTIME
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
